/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.errcount;

import com.tencent.polaris.api.config.consumer.CircuitBreakerConfig;
import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreakResult;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.InstanceLocalValue;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.pojo.Subset;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.pb.CircuitBreakerProto;
import com.tencent.polaris.client.pojo.InstanceByProto;
import com.tencent.polaris.plugins.circuitbreaker.common.ChangeStateUtils;
import com.tencent.polaris.plugins.circuitbreaker.common.CircuitBreakUtils;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigGroup;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSet;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSetLocator;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenConfig;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenCounter;
import com.tencent.polaris.plugins.circuitbreaker.common.RuleIdentifier;
import com.tencent.polaris.plugins.circuitbreaker.common.StateMachine;
import com.tencent.polaris.plugins.circuitbreaker.errcount.Config;
import com.tencent.polaris.plugins.circuitbreaker.errcount.ConsecutiveCounter;
import com.tencent.polaris.plugins.circuitbreaker.errcount.StateMachineImpl;
import java.util.Collection;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsecutiveCircuitBreaker
extends Destroyable
implements CircuitBreaker,
PluginConfigProvider,
ConfigSetLocator<Config> {
    private static final Logger LOG = LoggerFactory.getLogger(ConsecutiveCircuitBreaker.class);
    private int id;
    private StateMachine<Config> stateMachine;
    private final Function<Integer, Object> create = integer -> new ConsecutiveCounter();
    private Extensions extensions;
    private FlowControlParam flowControlParam;
    private LocalRegistry localRegistry;
    private ConfigGroup<Config> configGroup;

    public CircuitBreakResult checkInstance(Collection<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return null;
        }
        StateMachine.Parameter parameter = new StateMachine.Parameter(this.id, this.getName(), this.configGroup.getLocalConfig().getHalfOpenConfig().getHalfOpenMaxReqCount());
        return ChangeStateUtils.buildCircuitBreakResult(this.stateMachine, instances, (StateMachine.Parameter)parameter);
    }

    public CircuitBreakResult checkSubset(Collection<Subset> subsets) {
        return null;
    }

    public boolean stat(InstanceGauge gauge) {
        InstanceByProto instance = ChangeStateUtils.getInstance((InstanceGauge)gauge, (LocalRegistry)this.localRegistry);
        if (null == instance) {
            return false;
        }
        InstanceLocalValue instanceLocalValue = instance.getInstanceLocalValue();
        if (null == instanceLocalValue) {
            return false;
        }
        ConfigSet configSet = CircuitBreakUtils.getConfigSet((InstanceGauge)gauge, (ConfigSetLocator)this);
        StatusDimension statusDimension = ChangeStateUtils.buildStatusDimension((InstanceGauge)gauge, (StatusDimension.Level)configSet.getLevel());
        if (CircuitBreakUtils.instanceClose((Instance)instance, (StatusDimension)statusDimension)) {
            int failCount;
            Object pluginValue = instanceLocalValue.getPluginValue(this.id, this.create);
            ConsecutiveCounter consecutiveCounter = (ConsecutiveCounter)((Object)pluginValue);
            RetStatus retStatus = gauge.getRetStatus();
            if (retStatus == RetStatus.RetFail) {
                failCount = consecutiveCounter.onFail(statusDimension);
            } else {
                consecutiveCounter.resetCounter(statusDimension);
                failCount = 0;
            }
            return failCount == ((Config)configSet.getPlugConfig()).getContinuousErrorThreshold();
        }
        if (CircuitBreakUtils.instanceHalfOpen((Instance)instance, (StatusDimension)statusDimension)) {
            Object pluginValue = instanceLocalValue.getPluginValue(this.id, this.create);
            HalfOpenCounter consecutiveCounter = (HalfOpenCounter)pluginValue;
            RetStatus retStatus = gauge.getRetStatus();
            return consecutiveCounter.triggerHalfOpenConversion(statusDimension, retStatus, configSet.getHalfOpenConfig());
        }
        return false;
    }

    public String getName() {
        return "errorCount";
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public PluginType getType() {
        return PluginTypes.CIRCUIT_BREAKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        CircuitBreakerConfig circuitBreakerConfig = ctx.getConfig().getConsumer().getCircuitBreaker();
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        HalfOpenConfig halfOpenConfig = new HalfOpenConfig(circuitBreakerConfig, outlierDetection);
        Config cfg = (Config)circuitBreakerConfig.getPluginConfig(this.getName(), Config.class);
        if (cfg == null) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("plugin %s config is missing", this.getName()));
        }
        ConfigSet configSet = new ConfigSet(StatusDimension.Level.SERVICE, false, halfOpenConfig, (Verifier)cfg);
        this.configGroup = new ConfigGroup(configSet);
        this.stateMachine = new StateMachineImpl(this.configGroup, this.id, this);
        this.flowControlParam = new DefaultFlowControlParam(ctx.getConfig().getGlobal().getAPI());
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        this.extensions = extensions;
        this.localRegistry = extensions.getLocalRegistry();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ConfigSet<Config> getConfigSet(RuleIdentifier ruleIdentifier) {
        return this.configGroup.getServiceConfig(ruleIdentifier, (Function)new Function<RuleIdentifier, ConfigSet<Config>>(){

            @Override
            public ConfigSet<Config> apply(RuleIdentifier ruleIdentifier) {
                CircuitBreakerProto.CbPolicy.ConsecutiveErrConfig consecutive;
                CircuitBreakUtils.RuleDestinationResult ruleDestResultConsecutive = CircuitBreakUtils.getRuleDestinationSet((RuleIdentifier)ruleIdentifier, (Extensions)ConsecutiveCircuitBreaker.this.extensions, (FlowControlParam)ConsecutiveCircuitBreaker.this.flowControlParam);
                CircuitBreakerProto.DestinationSet ruleDestinationSetConsecutive = ruleDestResultConsecutive.getDestinationSet();
                if (null == ruleDestinationSetConsecutive) {
                    return new ConfigSet(StatusDimension.Level.SERVICE, true, null, null);
                }
                HalfOpenConfig halfOpenConfigConsecutive = ConsecutiveCircuitBreaker.this.configGroup.getLocalConfig().getHalfOpenConfig();
                CircuitBreakerProto.RecoverConfig recoverConfigConsecutive = ruleDestinationSetConsecutive.getRecover();
                if (null != recoverConfigConsecutive) {
                    halfOpenConfigConsecutive = new HalfOpenConfig(halfOpenConfigConsecutive, recoverConfigConsecutive);
                }
                Config targetPlugConfig = (Config)ConsecutiveCircuitBreaker.this.configGroup.getLocalConfig().getPlugConfig();
                CircuitBreakerProto.CbPolicy policy = ruleDestinationSetConsecutive.getPolicy();
                if (null != policy && null != (consecutive = policy.getConsecutive()) && consecutive.hasEnable() && consecutive.getEnable().getValue()) {
                    targetPlugConfig = new Config();
                    targetPlugConfig.setContinuousErrorThreshold(consecutive.getConsecutiveErrorToOpen().getValue());
                }
                return new ConfigSet(ruleDestResultConsecutive.getMatchLevel(), false, halfOpenConfigConsecutive, (Verifier)targetPlugConfig);
            }
        });
    }
}

