/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.errrate;

import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.plugins.circuitbreaker.common.AbstractStateMachine;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigGroup;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSet;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSetLocator;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenCounter;
import com.tencent.polaris.plugins.circuitbreaker.common.StateMachine;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.SliceWindow;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.TimeRange;
import com.tencent.polaris.plugins.circuitbreaker.errrate.Config;
import com.tencent.polaris.plugins.circuitbreaker.errrate.Dimension;
import com.tencent.polaris.plugins.circuitbreaker.errrate.ErrRateCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineImpl
extends AbstractStateMachine<Config> {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachineImpl.class);
    private final long metricTimeWindowMs;

    public StateMachineImpl(ConfigGroup<Config> configGroup, int pluginId, ConfigSetLocator<Config> configSetLocator, long metricTimeWindowMs) {
        super(configGroup, pluginId, configSetLocator);
        this.metricTimeWindowMs = metricTimeWindowMs;
    }

    public boolean closeToOpen(Instance instance, StatusDimension statusDimension, StateMachine.Parameter parameter) {
        HalfOpenCounter halfOpenCounter = this.getHalfOpenCounterOnClose(instance, statusDimension);
        if (halfOpenCounter == null) {
            return false;
        }
        ConfigSet configSet = this.getConfigSetByLocator(instance, statusDimension, this.configSetLocator);
        Config plugConfig = (Config)configSet.getPlugConfig();
        ErrRateCounter errRateCounter = (ErrRateCounter)halfOpenCounter;
        SliceWindow metricWindow = errRateCounter.getSliceWindow(statusDimension);
        long currentTimeMs = parameter.getCurrentTimeMs();
        TimeRange timeRange = new TimeRange(currentTimeMs - this.metricTimeWindowMs, currentTimeMs);
        long requestCount = metricWindow.calcMetricsBothIncluded(Dimension.keyRequestCount.ordinal(), timeRange);
        if (requestCount == 0L || requestCount < (long)plugConfig.getRequestVolumeThreshold().intValue()) {
            return false;
        }
        long failCount = metricWindow.calcMetricsBothIncluded(Dimension.keyFailCount.ordinal(), timeRange);
        double failRatio = (double)failCount / (double)requestCount;
        LOG.debug("errRate statistic: request count {}, fail count {}, instance {}:{}, dimension {}, failRatio {}", new Object[]{requestCount, failCount, instance.getHost(), instance.getPort(), statusDimension, failRatio});
        return failRatio >= plugConfig.getErrRate();
    }
}

