/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.errrate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.client.pb.CircuitBreakerProto;
import com.tencent.polaris.factory.util.ConfigUtils;

public class Config
implements Verifier {
    @JsonProperty
    private Integer requestVolumeThreshold;
    @JsonProperty
    private Integer errorRateThreshold;
    @JsonProperty
    private Integer metricNumBuckets;
    @JsonIgnore
    private double errRate;

    public Config() {
    }

    public Config(Config config, CircuitBreakerProto.CbPolicy.ErrRateConfig errRateConfig) {
        this.setRequestVolumeThreshold(config.getRequestVolumeThreshold());
        this.setMetricNumBuckets(config.getMetricNumBuckets());
        this.setErrorRateThreshold(config.getErrorRateThreshold());
        if (null != errRateConfig) {
            this.setErrorRateThreshold(errRateConfig.getErrorRateToOpen().getValue());
        }
    }

    public Integer getRequestVolumeThreshold() {
        return this.requestVolumeThreshold;
    }

    public void setRequestVolumeThreshold(Integer requestVolumeThreshold) {
        this.requestVolumeThreshold = requestVolumeThreshold;
    }

    public Integer getErrorRateThreshold() {
        return this.errorRateThreshold;
    }

    public double getErrRate() {
        return this.errRate;
    }

    public void setErrorRateThreshold(Integer errorRateThreshold) {
        this.errorRateThreshold = errorRateThreshold;
        if (null == this.errorRateThreshold) {
            return;
        }
        double errorRate = (double)this.errorRateThreshold.intValue() / 100.0;
        if (errorRate > 1.0) {
            errorRate = 1.0;
        }
        this.errRate = errorRate;
    }

    public Integer getMetricNumBuckets() {
        return this.metricNumBuckets;
    }

    public void setMetricNumBuckets(Integer metricNumBuckets) {
        this.metricNumBuckets = metricNumBuckets;
    }

    public void verify() {
        ConfigUtils.validatePositive((Integer)this.requestVolumeThreshold, (String)"requestVolumeThreshold");
        ConfigUtils.validatePositive((Integer)this.errorRateThreshold, (String)"errorRateThreshold");
        ConfigUtils.validatePositive((Integer)this.metricNumBuckets, (String)"metricNumBuckets");
        if (this.errorRateThreshold > 100) {
            throw new IllegalArgumentException("errorRateThreshold should be less than or equals to 100");
        }
    }

    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            Config config = (Config)defaultObject;
            if (null == this.requestVolumeThreshold) {
                this.setRequestVolumeThreshold(config.getRequestVolumeThreshold());
            }
            if (null == this.errorRateThreshold) {
                this.setErrorRateThreshold(config.getErrorRateThreshold());
            }
            if (null == this.metricNumBuckets) {
                this.setMetricNumBuckets(config.getMetricNumBuckets());
            }
        }
    }

    public String toString() {
        return "Config{requestVolumeThreshold=" + this.requestVolumeThreshold + ", errorRateThreshold=" + this.errorRateThreshold + ", metricNumBuckets=" + this.metricNumBuckets + '}';
    }
}

