/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.composite;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.server.CommonProviderRequest;
import com.tencent.polaris.api.plugin.server.CommonProviderResponse;
import com.tencent.polaris.api.plugin.server.CommonServiceContractRequest;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.plugin.server.ReportServiceContractRequest;
import com.tencent.polaris.api.plugin.server.ReportServiceContractResponse;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import com.tencent.polaris.plugins.connector.composite.CompositeServiceUpdateTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CompositeConnector
extends DestroyableServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeConnector.class);
    private List<DestroyableServerConnector> serverConnectors;
    private boolean initialized = false;
    private ScheduledThreadPoolExecutor sendDiscoverExecutor;
    private ScheduledThreadPoolExecutor updateServiceExecutor;

    public String getName() {
        return "composite";
    }

    public String getId() {
        return "composite";
    }

    public boolean isRegisterEnable() {
        return true;
    }

    public boolean isDiscoveryEnable() {
        return true;
    }

    public boolean isReportServiceContractEnable() {
        return true;
    }

    public PluginType getType() {
        return PluginTypes.SERVER_CONNECTOR.getBaseType();
    }

    public List<DestroyableServerConnector> getServerConnectors() {
        return this.serverConnectors;
    }

    public void init(InitContext ctx) throws PolarisException {
        if (this.getName().equals(ctx.getValueContext().getServerConnectorProtocol())) {
            if (CollectionUtils.isEmpty(this.serverConnectors)) {
                this.serverConnectors = new ArrayList<DestroyableServerConnector>();
            }
            List serverConnectorConfigs = ctx.getConfig().getGlobal().getServerConnectors();
            for (ServerConnectorConfigImpl serverConnectorConfig : serverConnectorConfigs) {
                DestroyableServerConnector serverConnector = (DestroyableServerConnector)ctx.getPlugins().getPlugin(PluginTypes.SERVER_CONNECTOR.getBaseType(), serverConnectorConfig.getProtocol());
                serverConnector.init(ctx);
                this.serverConnectors.add(serverConnector);
            }
            this.sendDiscoverExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory(this.getName() + "-send-discovery"), new ThreadPoolExecutor.CallerRunsPolicy());
            this.sendDiscoverExecutor.setMaximumPoolSize(1);
            this.updateServiceExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory(this.getName() + "-update-service"));
            this.updateServiceExecutor.setMaximumPoolSize(1);
            this.initialized = true;
        }
    }

    public void postContextInit(Extensions ctx) throws PolarisException {
        if (this.initialized) {
            this.updateServiceExecutor.scheduleWithFixedDelay((Runnable)new DestroyableServerConnector.UpdateServiceTask((DestroyableServerConnector)this), 500L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void registerServiceHandler(ServiceEventHandler handler) throws PolarisException {
        this.checkDestroyed();
        CompositeServiceUpdateTask serviceUpdateTask = new CompositeServiceUpdateTask(handler, this);
        this.submitServiceHandler(serviceUpdateTask, 0L);
    }

    public void deRegisterServiceHandler(ServiceEventKey eventKey) throws PolarisException {
        this.checkDestroyed();
        ServiceUpdateTask serviceUpdateTask = (ServiceUpdateTask)this.updateTaskSet.get(eventKey);
        if (null != serviceUpdateTask) {
            boolean result = serviceUpdateTask.setType(ServiceUpdateTaskConstant.Type.LONG_RUNNING, ServiceUpdateTaskConstant.Type.TERMINATED);
            LOG.info("[ServerConnector]success to deRegister updateServiceTask {}, result is {}", (Object)eventKey, (Object)result);
        }
    }

    public CommonProviderResponse registerInstance(CommonProviderRequest req, Map<String, String> customHeader) throws PolarisException {
        this.checkDestroyed();
        CommonProviderResponse response = null;
        CommonProviderResponse extendResponse = null;
        for (DestroyableServerConnector sc : this.serverConnectors) {
            CommonProviderResponse temp = sc.registerInstance(req, customHeader);
            if ("grpc".equals(sc.getName())) {
                response = temp;
                continue;
            }
            if (null != extendResponse) continue;
            extendResponse = temp;
        }
        if (null == response) {
            response = extendResponse;
        }
        if (null == response) {
            throw new PolarisException(ErrorCode.INTERNAL_ERROR, "No one server can be registered.");
        }
        return response;
    }

    public void deregisterInstance(CommonProviderRequest req) throws PolarisException {
        this.checkDestroyed();
        for (DestroyableServerConnector sc : this.serverConnectors) {
            sc.deregisterInstance(req);
        }
    }

    public void heartbeat(CommonProviderRequest req) throws PolarisException {
        this.checkDestroyed();
        for (DestroyableServerConnector sc : this.serverConnectors) {
            sc.heartbeat(req);
        }
    }

    public ReportClientResponse reportClient(ReportClientRequest req) throws PolarisException {
        this.checkDestroyed();
        ReportClientResponse response = null;
        for (DestroyableServerConnector sc : this.serverConnectors) {
            ReportClientResponse temp = sc.reportClient(req);
            if (!"grpc".equals(sc.getName())) continue;
            response = temp;
        }
        return response;
    }

    public ReportServiceContractResponse reportServiceContract(ReportServiceContractRequest req) throws PolarisException {
        this.checkDestroyed();
        ReportServiceContractResponse response = null;
        for (DestroyableServerConnector sc : this.serverConnectors) {
            ReportServiceContractResponse temp = sc.reportServiceContract(req);
            if (!"grpc".equals(sc.getName())) continue;
            response = temp;
        }
        return response;
    }

    public ServiceRuleByProto getServiceContract(CommonServiceContractRequest req) throws PolarisException {
        this.checkDestroyed();
        ServiceRuleByProto response = null;
        for (DestroyableServerConnector sc : this.serverConnectors) {
            ServiceRuleByProto temp = sc.getServiceContract(req);
            if (!"grpc".equals(sc.getName())) continue;
            response = temp;
        }
        return response;
    }

    public void updateServers(ServiceEventKey svcEventKey) {
        for (DestroyableServerConnector sc : this.serverConnectors) {
            sc.updateServers(svcEventKey);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void submitServiceHandler(ServiceUpdateTask updateTask, long delayMs) {
        LOG.debug("[ServerConnector]task for service {} has been scheduled discover", (Object)updateTask);
        this.sendDiscoverExecutor.schedule((Runnable)updateTask, delayMs, TimeUnit.MILLISECONDS);
    }
}

