/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.composite;

import com.google.protobuf.BoolValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt32Value;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pb.ServiceProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import com.tencent.polaris.plugins.connector.composite.CompositeConnector;
import com.tencent.polaris.plugins.connector.grpc.GrpcServiceUpdateTask;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class CompositeServiceUpdateTask
extends ServiceUpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeServiceUpdateTask.class);

    public CompositeServiceUpdateTask(ServiceEventHandler handler, DestroyableServerConnector connector) {
        super(handler, connector);
    }

    protected void execute() {
        CompositeConnector connector = (CompositeConnector)this.serverConnector;
        for (DestroyableServerConnector sc : connector.getServerConnectors()) {
            if (!"grpc".equals(sc.getName()) || !sc.isDiscoveryEnable()) continue;
            GrpcServiceUpdateTask grpcServiceUpdateTask = new GrpcServiceUpdateTask(this.serviceEventHandler, sc);
            grpcServiceUpdateTask.execute((ServiceUpdateTask)this);
            return;
        }
        boolean svcDeleted = this.notifyServerEvent(new ServerEvent(this.serviceEventKey, (Object)ResponseProto.DiscoverResponse.newBuilder().build(), null));
        if (!svcDeleted) {
            this.addUpdateTaskSet();
        }
    }

    protected void handle(Throwable throwable) {
        LOG.error("Composite service task execute error.", throwable);
    }

    public boolean notifyServerEvent(ServerEvent serverEvent) {
        this.taskStatus.compareAndSet(ServiceUpdateTaskConstant.Status.RUNNING, ServiceUpdateTaskConstant.Status.READY);
        this.lastUpdateTime.set(System.currentTimeMillis());
        try {
            if (serverEvent.getValue() instanceof ResponseProto.DiscoverResponse) {
                ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)serverEvent.getValue();
                ResponseProto.DiscoverResponse.Builder newDiscoverResponseBuilder = ResponseProto.DiscoverResponse.newBuilder().mergeFrom(discoverResponse);
                CompositeConnector connector = (CompositeConnector)this.serverConnector;
                if (ServiceEventKey.EventType.INSTANCE.equals((Object)this.serviceEventKey.getEventType())) {
                    ArrayList extendInstanceList = new ArrayList();
                    for (DestroyableServerConnector destroyableServerConnector : connector.getServerConnectors()) {
                        if ("grpc".equals(destroyableServerConnector.getName()) || !destroyableServerConnector.isDiscoveryEnable()) continue;
                        List instanceList = destroyableServerConnector.syncGetServiceInstances((ServiceUpdateTask)this);
                        if (!extendInstanceList.isEmpty()) continue;
                        extendInstanceList.addAll(instanceList);
                    }
                    List polarisInstanceList = discoverResponse.getInstancesList();
                    for (DefaultInstance i : extendInstanceList) {
                        boolean needAdd = true;
                        for (ServiceProto.Instance j : polarisInstanceList) {
                            if (!i.getHost().equals(j.getHost().getValue()) || i.getPort() != j.getPort().getValue()) continue;
                            needAdd = false;
                            break;
                        }
                        if (!needAdd) continue;
                        ServiceProto.Instance.Builder instanceBuilder = ServiceProto.Instance.newBuilder().setNamespace(StringValue.of((String)this.serviceEventKey.getNamespace())).setService(StringValue.of((String)i.getService())).setHost(StringValue.of((String)i.getHost())).setPort(UInt32Value.of((int)i.getPort())).setHealthy(BoolValue.of((boolean)true));
                        if (StringUtils.isNotBlank((String)i.getId())) {
                            instanceBuilder.setId(StringValue.of((String)i.getId()));
                        }
                        newDiscoverResponseBuilder.addInstances(instanceBuilder.build());
                    }
                    if (!newDiscoverResponseBuilder.getInstancesList().isEmpty()) {
                        serverEvent.setError(null);
                    }
                } else if (ServiceEventKey.EventType.SERVICE.equals((Object)this.serviceEventKey.getEventType())) {
                    ArrayList extendServiceList = new ArrayList();
                    for (DestroyableServerConnector destroyableServerConnector : connector.getServerConnectors()) {
                        if ("grpc".equals(destroyableServerConnector.getName()) || !destroyableServerConnector.isDiscoveryEnable()) continue;
                        Services services = destroyableServerConnector.syncGetServices((ServiceUpdateTask)this);
                        if (!extendServiceList.isEmpty()) continue;
                        extendServiceList.addAll(services.getServices());
                    }
                    List polarisServiceList = discoverResponse.getServicesList();
                    for (ServiceInfo i : extendServiceList) {
                        boolean needAdd = true;
                        for (ServiceProto.Service j : polarisServiceList) {
                            if (!i.getService().equals(j.getName().getValue())) continue;
                            needAdd = false;
                            break;
                        }
                        if (!needAdd) continue;
                        ServiceProto.Service service = ServiceProto.Service.newBuilder().setNamespace(StringValue.of((String)this.serviceEventKey.getNamespace())).setName(StringValue.of((String)i.getService())).build();
                        newDiscoverResponseBuilder.addServices(service);
                    }
                    if (!newDiscoverResponseBuilder.getServicesList().isEmpty()) {
                        serverEvent.setError(null);
                    }
                }
                serverEvent.setValue((Object)newDiscoverResponseBuilder.build());
            }
        }
        catch (PolarisException e) {
            LOG.error("Merge other server response failed.", (Throwable)e);
            serverEvent.setError(e);
        }
        catch (Throwable throwable) {
            LOG.error("Merge other server response failed.", throwable);
            serverEvent.setError(new PolarisException(ErrorCode.INTERNAL_ERROR));
        }
        if (null == serverEvent.getError()) {
            this.successUpdates.addAndGet(1L);
        }
        return this.getEventHandler().onEventUpdate(serverEvent);
    }
}

