/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.composite.zero;

import com.google.protobuf.BoolValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt32Value;
import com.tencent.polaris.api.config.consumer.ZeroProtectionConfig;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.composite.CompositeServiceUpdateTask;
import com.tencent.polaris.plugins.connector.composite.zero.NetUtils;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class TestConnectivityTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TestConnectivityTask.class);
    private final CompositeServiceUpdateTask compositeServiceUpdateTask;
    private final ResponseProto.DiscoverResponse discoverResponse;
    private final ZeroProtectionConfig zeroProtectionConfig;
    private Set<ServiceKey> currentTestConnectivityTaskServiceKeys;
    public static final String REVISION_PREFIX = "zero-protect-";

    public TestConnectivityTask(CompositeServiceUpdateTask compositeServiceUpdateTask, ResponseProto.DiscoverResponse discoverResponse, ZeroProtectionConfig zeroProtectionConfig) {
        this.compositeServiceUpdateTask = compositeServiceUpdateTask;
        this.discoverResponse = discoverResponse;
        this.zeroProtectionConfig = zeroProtectionConfig;
    }

    @Override
    public void run() {
        try {
            List originalList = this.discoverResponse.getInstancesList();
            ArrayList<ServiceProto.Instance> zeroProtect = new ArrayList<ServiceProto.Instance>();
            ExecutorService executorService = Executors.newFixedThreadPool(this.zeroProtectionConfig.getTestConnectivityParallel());
            CountDownLatch latch = new CountDownLatch(originalList.size());
            AtomicInteger passingCount = new AtomicInteger(0);
            AtomicInteger notPassingCount = new AtomicInteger(0);
            AtomicInteger isolateCount = new AtomicInteger(0);
            for (ServiceProto.Instance instance : originalList) {
                if (this.isPassing(instance)) {
                    executorService.submit(() -> {
                        if (NetUtils.testConnectivity(instance.getHost().getValue(), instance.getPort().getValue(), this.zeroProtectionConfig.getTestConnectivityTimeout())) {
                            zeroProtect.add(ServiceProto.Instance.newBuilder((ServiceProto.Instance)instance).setHealthy(BoolValue.of((boolean)true)).build());
                            passingCount.incrementAndGet();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Instance[{}:{}] of {} is tested passing.", new Object[]{instance.getHost().getValue(), instance.getPort().getValue(), instance.getService().getValue()});
                            }
                        } else {
                            zeroProtect.add(ServiceProto.Instance.newBuilder((ServiceProto.Instance)instance).setHealthy(BoolValue.of((boolean)false)).build());
                            notPassingCount.incrementAndGet();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Instance[{}:{}] of {} is tested not passing.", new Object[]{instance.getHost().getValue(), instance.getPort().getValue(), instance.getService().getValue()});
                            }
                        }
                        latch.countDown();
                    });
                    continue;
                }
                zeroProtect.add(instance);
                isolateCount.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Instance[{}:{}] of {} is isolated, skip test.", new Object[]{instance.getHost().getValue(), instance.getPort().getValue(), instance.getService().getValue()});
                }
                latch.countDown();
            }
            if (!latch.await(2L * (long)this.zeroProtectionConfig.getTestConnectivityTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.error("Test connectivity is interrupted. original size: {}, zero protect size: {}.", (Object)originalList.size(), (Object)zeroProtect.size());
            } else {
                LOG.info("Test end. Passing count: {}, not passing count: {}, isolate count: {}.", new Object[]{passingCount.get(), notPassingCount.get(), isolateCount.get()});
            }
            ResponseProto.DiscoverResponse.Builder newDiscoverResponseBuilder = ResponseProto.DiscoverResponse.newBuilder().mergeFrom(this.discoverResponse);
            String oldRevision = this.discoverResponse.getService().getRevision().getValue();
            newDiscoverResponseBuilder.setCode(UInt32Value.of((int)200000));
            newDiscoverResponseBuilder.clearInstances();
            newDiscoverResponseBuilder.addAllInstances(zeroProtect);
            String newRevision = REVISION_PREFIX + System.currentTimeMillis();
            ServiceProto.Service.Builder newServiceBuilder = ServiceProto.Service.newBuilder().mergeFrom(newDiscoverResponseBuilder.getService());
            newServiceBuilder.setRevision(StringValue.of((String)newRevision));
            newDiscoverResponseBuilder.setService(newServiceBuilder.build());
            this.compositeServiceUpdateTask.notifyServerEventWithRevisionChecking(new ServerEvent(this.compositeServiceUpdateTask.getServiceEventKey(), (Object)newDiscoverResponseBuilder.build(), null), oldRevision);
            this.currentTestConnectivityTaskServiceKeys.remove(this.compositeServiceUpdateTask.getServiceEventKey().getServiceKey());
        }
        catch (Exception e) {
            LOG.error("Test connectivity failed.", (Throwable)e);
        }
    }

    private boolean isPassing(ServiceProto.Instance instance) {
        return instance != null && !instance.getIsolate().getValue();
    }

    public CompositeServiceUpdateTask getCompositeServiceUpdateTask() {
        return this.compositeServiceUpdateTask;
    }

    public ResponseProto.DiscoverResponse getDiscoverResponse() {
        return this.discoverResponse;
    }

    public ZeroProtectionConfig getZeroProtectionConfig() {
        return this.zeroProtectionConfig;
    }

    public Set<ServiceKey> getCurrentTestConnectivityTaskServiceKeys() {
        return this.currentTestConnectivityTaskServiceKeys;
    }

    public void setCurrentTestConnectivityTaskServiceKeys(Set<ServiceKey> currentTestConnectivityTaskServiceKeys) {
        this.currentTestConnectivityTaskServiceKeys = currentTestConnectivityTaskServiceKeys;
    }
}

