/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.consul;

import com.ecwid.consul.ConsulException;
import com.ecwid.consul.v1.ConsistencyMode;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import com.tencent.polaris.api.config.global.ServerConnectorConfig;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.exception.ServerErrorResponseException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.server.CommonProviderRequest;
import com.tencent.polaris.api.plugin.server.CommonProviderResponse;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.ServicesByProto;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.consul.ConsulContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ConsulAPIConnector
extends DestroyableServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulAPIConnector.class);
    private boolean initialized = false;
    private boolean ieRegistered = false;
    private ConsulClient consulClient;
    private ConsulContext consulContext;

    public String getName() {
        return "consul";
    }

    public PluginType getType() {
        return PluginTypes.SERVER_CONNECTOR.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        List serverConnectorConfigs;
        if (!this.initialized && CollectionUtils.isNotEmpty((Collection)(serverConnectorConfigs = ctx.getConfig().getGlobal().getServerConnectors()))) {
            for (ServerConnectorConfigImpl serverConnectorConfig : serverConnectorConfigs) {
                if (!"consul".equals(serverConnectorConfig.getProtocol())) continue;
                this.initActually(ctx, (ServerConnectorConfig)serverConnectorConfig);
            }
        }
    }

    private void initActually(InitContext ctx, ServerConnectorConfig connectorConfig) {
        String address = (String)connectorConfig.getAddresses().get(0);
        int lastIndex = address.lastIndexOf(":");
        String agentHost = address.substring(0, lastIndex);
        int agentPort = Integer.parseInt(address.substring(lastIndex + 1));
        this.consulClient = new ConsulClient(agentHost, agentPort);
        this.consulContext = new ConsulContext();
        Map metadata = connectorConfig.getMetadata();
        if (metadata.containsKey("SERVICE_NAME_KEY") && StringUtils.isNotBlank((String)((String)metadata.get("SERVICE_NAME_KEY")))) {
            this.consulContext.setServiceName((String)metadata.get("SERVICE_NAME_KEY"));
        }
        if (metadata.containsKey("INSTANCE_ID_KEY") && StringUtils.isNotBlank((String)((String)metadata.get("INSTANCE_ID_KEY")))) {
            this.consulContext.setInstanceId((String)metadata.get("INSTANCE_ID_KEY"));
        }
        if (metadata.containsKey("IP_ADDRESS_KEY") && StringUtils.isNotBlank((String)((String)metadata.get("IP_ADDRESS_KEY")))) {
            this.consulContext.setIpAddress((String)metadata.get("IP_ADDRESS_KEY"));
        }
        if (metadata.containsKey("PREFER_IP_ADDRESS_KEY") && StringUtils.isNotBlank((String)((String)metadata.get("PREFER_IP_ADDRESS_KEY")))) {
            this.consulContext.setPreferIpAddress(Boolean.parseBoolean((String)metadata.get("PREFER_IP_ADDRESS_KEY")));
        }
        this.initialized = true;
    }

    public void postContextInit(Extensions ctx) throws PolarisException {
    }

    public void registerServiceHandler(ServiceEventHandler handler) throws PolarisException {
    }

    public void deRegisterServiceHandler(ServiceEventKey eventKey) throws PolarisException {
    }

    public CommonProviderResponse registerInstance(CommonProviderRequest req) throws PolarisException {
        if (!this.ieRegistered) {
            ServiceKey serviceKey = new ServiceKey(req.getNamespace(), req.getService());
            try {
                LOG.info("Registering service to Consul");
                NewService service = this.buildRegisterInstanceRequest(req);
                this.consulClient.agentServiceRegister(service);
                CommonProviderResponse resp = new CommonProviderResponse();
                this.consulContext.setInstanceId(service.getId());
                resp.setInstanceID(service.getId());
                resp.setExists(true);
                LOG.info("Registered service to Consul: " + service);
                this.ieRegistered = true;
                return resp;
            }
            catch (ConsulException e) {
                throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("fail to register host %s:%d service %s", req.getHost(), req.getPort(), serviceKey), (Throwable)e);
            }
        }
        return null;
    }

    private NewService buildRegisterInstanceRequest(CommonProviderRequest req) {
        NewService service = new NewService();
        String appName = req.getService();
        if (this.consulContext.isPreferIpAddress()) {
            service.setAddress(this.consulContext.getIpAddress());
        } else {
            service.setAddress(req.getHost());
        }
        if (StringUtils.isBlank((String)req.getInstanceID())) {
            if (StringUtils.isBlank((String)this.consulContext.getInstanceId())) {
                this.consulContext.setInstanceId(appName + "-" + service.getAddress().replace(".", "-") + "-" + req.getPort());
            }
            service.setId(this.consulContext.getInstanceId());
        } else {
            service.setId(req.getInstanceID());
        }
        service.setPort(Integer.valueOf(req.getPort()));
        if (StringUtils.isBlank((String)this.consulContext.getServiceName())) {
            this.consulContext.setServiceName(appName);
        }
        service.setName(this.consulContext.getServiceName());
        service.setMeta(req.getMetadata());
        if (null != req.getTtl()) {
            NewService.Check check = new NewService.Check();
            check.setTtl((double)req.getTtl().intValue() * 1.5 + "s");
            service.setCheck(check);
        }
        return service;
    }

    public void deregisterInstance(CommonProviderRequest req) throws PolarisException {
        if (this.ieRegistered) {
            ServiceKey serviceKey = new ServiceKey(req.getNamespace(), req.getService());
            try {
                LOG.info("Unregistering service to Consul: " + this.consulContext.getInstanceId());
                this.consulClient.agentServiceDeregister(this.consulContext.getInstanceId());
                LOG.info("Unregistered service to Consul: " + this.consulContext.getInstanceId());
                this.ieRegistered = false;
            }
            catch (ConsulException e) {
                throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("fail to deregister host %s:%d service %s", req.getHost(), req.getPort(), serviceKey), (Throwable)e);
            }
        }
    }

    public void heartbeat(CommonProviderRequest req) throws PolarisException {
        if (this.ieRegistered) {
            ServiceKey serviceKey = new ServiceKey(req.getNamespace(), req.getService());
            try {
                this.consulClient.agentCheckPass("service:" + this.consulContext.getInstanceId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Heartbeat service to Consul: " + this.consulContext.getInstanceId());
                }
            }
            catch (ConsulException e) {
                throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("fail to heartbeat id %s, host %s:%d service %s", req.getInstanceID(), req.getHost(), req.getPort(), serviceKey), (Throwable)e);
            }
        }
    }

    public List<DefaultInstance> syncGetServiceInstances(ServiceUpdateTask serviceUpdateTask) {
        ArrayList<DefaultInstance> instanceList = new ArrayList<DefaultInstance>();
        try {
            HealthServicesRequest request = HealthServicesRequest.newBuilder().setQueryParams(new QueryParams(ConsistencyMode.DEFAULT)).build();
            Response response = this.consulClient.getHealthServices(serviceUpdateTask.getServiceEventKey().getService(), request);
            if (response.getValue() == null || ((List)response.getValue()).isEmpty()) {
                return Collections.emptyList();
            }
            for (HealthService service : (List)response.getValue()) {
                DefaultInstance instance = new DefaultInstance();
                instance.setId(service.getService().getId());
                instance.setService(service.getService().getService());
                instance.setHost(service.getService().getAddress());
                instance.setPort(service.getService().getPort().intValue());
                instanceList.add(instance);
            }
        }
        catch (ConsulException e) {
            throw ServerErrorResponseException.build((int)ErrorCode.SERVER_USER_ERROR.ordinal(), (String)String.format("Get service instances of %s sync failed.", serviceUpdateTask.getServiceEventKey().getServiceKey()));
        }
        return instanceList;
    }

    public Services syncGetServices(ServiceUpdateTask serviceUpdateTask) {
        ServicesByProto services = new ServicesByProto(new ArrayList());
        try {
            CatalogServicesRequest request = CatalogServicesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build();
            ArrayList serviceList = new ArrayList(((Map)this.consulClient.getCatalogServices(request).getValue()).keySet());
            for (String s : serviceList) {
                ServiceInfo serviceInfo = new ServiceInfo();
                serviceInfo.setService(s);
                services.getServices().add(serviceInfo);
            }
        }
        catch (ConsulException e) {
            throw ServerErrorResponseException.build((int)ErrorCode.SERVER_USER_ERROR.ordinal(), (String)String.format("Get services of %s instances sync failed.", serviceUpdateTask.getServiceEventKey().getServiceKey()));
        }
        return services;
    }

    public ReportClientResponse reportClient(ReportClientRequest req) throws PolarisException {
        return null;
    }

    public void updateServers(ServiceEventKey svcEventKey) {
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void retryServiceUpdateTask(ServiceUpdateTask updateTask) {
    }

    protected void submitServiceHandler(ServiceUpdateTask updateTask, long delayMs) {
    }

    public void addLongRunningTask(ServiceUpdateTask serviceUpdateTask) {
    }
}

