/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.tencent.polaris.api.config.consumer.DiscoveryConfig;
import com.tencent.polaris.api.config.global.ServerConnectorConfig;
import com.tencent.polaris.api.config.provider.RegisterConfig;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.exception.ServerErrorResponseException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.server.CommonProviderRequest;
import com.tencent.polaris.api.plugin.server.CommonProviderResponse;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.ServicesByProto;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.ServiceInstancesResponse;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConnector
extends DestroyableServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(NacosConnector.class);
    private static final String INSTANCE_NAME = "%s$%s@@%s#%s#%d";
    private final AtomicBoolean initialized = new AtomicBoolean();
    private String id;
    private boolean isRegisterEnable = true;
    private boolean isDiscoveryEnable = true;
    private Properties nacosProperties = new Properties();
    private final Map<String, NamingService> namingServices = new ConcurrentHashMap<String, NamingService>();
    private final Map<String, NacosServiceMerger> mergers = new ConcurrentHashMap<String, NacosServiceMerger>();
    private final Object lock = new Object();
    private static final int NACOS_SERVICE_PAGESIZE = 10;

    public String getName() {
        return "nacos";
    }

    public PluginType getType() {
        return PluginTypes.SERVER_CONNECTOR.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        List serverConnectorConfigs;
        if (this.initialized.compareAndSet(false, true) && CollectionUtils.isNotEmpty((Collection)(serverConnectorConfigs = ctx.getConfig().getGlobal().getServerConnectors()))) {
            for (ServerConnectorConfigImpl serverConnectorConfig : serverConnectorConfigs) {
                if (!"nacos".equals(serverConnectorConfig.getProtocol())) continue;
                this.initActually(ctx, (ServerConnectorConfig)serverConnectorConfig);
            }
        }
    }

    private void initActually(InitContext ctx, ServerConnectorConfig connectorConfig) {
        this.id = connectorConfig.getId();
        if (ctx.getConfig().getProvider().getRegisterConfigMap().containsKey(this.id)) {
            this.isRegisterEnable = ((RegisterConfig)ctx.getConfig().getProvider().getRegisterConfigMap().get(this.id)).isEnable();
        }
        if (ctx.getConfig().getConsumer().getDiscoveryConfigMap().containsKey(this.id)) {
            this.isDiscoveryEnable = ((DiscoveryConfig)ctx.getConfig().getConsumer().getDiscoveryConfigMap().get(this.id)).isEnable();
        }
        this.nacosProperties = this.decodeNacosConfigProperties(connectorConfig);
    }

    private Properties decodeNacosConfigProperties(ServerConnectorConfig config) {
        Properties properties = new Properties();
        Map metadata = Optional.ofNullable(config.getMetadata()).orElse(new HashMap());
        if (Objects.nonNull(metadata.get("username"))) {
            properties.put("username", metadata.get("username"));
        }
        if (Objects.nonNull(metadata.get("password"))) {
            properties.put("password", metadata.get("password"));
        }
        if (Objects.nonNull(metadata.get("contextPath"))) {
            properties.put("contextPath", metadata.get("contextPath"));
        }
        properties.put("serverAddr", String.join((CharSequence)",", config.getAddresses()));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingService getOrCreateNamingService(String namespace) {
        NamingService namingService = this.namingServices.get(namespace);
        if (namingService != null) {
            return namingService;
        }
        Object object = this.lock;
        synchronized (object) {
            Properties properties = new Properties(this.nacosProperties);
            if (!Objects.equals(namespace, "default")) {
                properties.setProperty("namespace", namespace);
            }
            try {
                namingService = NacosFactory.createNamingService((Properties)properties);
            }
            catch (NacosException e) {
                LOG.error("[Connector][Nacos] fail to create naming service to {}, namespace {}", new Object[]{properties.get("serverAddr"), namespace, e});
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.namingServices.put(namespace, namingService);
            this.mergers.put(namespace, new NacosServiceMerger(namingService));
            return namingService;
        }
    }

    public void postContextInit(Extensions ctx) throws PolarisException {
    }

    public void registerServiceHandler(ServiceEventHandler handler) throws PolarisException {
    }

    public void deRegisterServiceHandler(ServiceEventKey eventKey) throws PolarisException {
    }

    public CommonProviderResponse registerInstance(CommonProviderRequest req, Map<String, String> customHeader) throws PolarisException {
        CommonProviderResponse response = new CommonProviderResponse();
        if (this.isRegisterEnable()) {
            NamingService namingService = this.getOrCreateNamingService(req.getNamespace());
            if (namingService == null) {
                LOG.error("[Nacos] fail to lookup namingService for service {}", (Object)req.getService());
                return null;
            }
            try {
                Instance instance = this.buildRegisterNacosInstance(req, NacosConnector.analyzeNacosGroup(req.getService()));
                namingService.registerInstance(NacosConnector.analyzeNacosService(req.getService()), NacosConnector.analyzeNacosGroup(req.getService()), instance);
                response.setInstanceID(instance.getInstanceId());
            }
            catch (NacosException e) {
                throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("[Connector][Nacos] fail to register host %s:%d service %s", req.getHost(), req.getPort(), req.getService()), (Throwable)e);
            }
        }
        return response;
    }

    public void deregisterInstance(CommonProviderRequest req) throws PolarisException {
        try {
            NamingService service = this.getOrCreateNamingService(req.getNamespace());
            if (service == null) {
                LOG.error("[Nacos] fail to lookup namingService for service {}", (Object)req.getService());
                return;
            }
            Instance instance = this.buildDeregisterNacosInstance(req, NacosConnector.analyzeNacosGroup(req.getService()));
            service.deregisterInstance(NacosConnector.analyzeNacosService(req.getService()), NacosConnector.analyzeNacosGroup(req.getService()), instance);
        }
        catch (NacosException e) {
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("[Connector][Nacos] fail to deregister host %s:%d service %s", req.getHost(), req.getPort(), req.getService()), (Throwable)e);
        }
    }

    public void heartbeat(CommonProviderRequest req) throws PolarisException {
    }

    public ReportClientResponse reportClient(ReportClientRequest req) throws PolarisException {
        return null;
    }

    public void updateServers(ServiceEventKey svcEventKey) {
    }

    public ServiceInstancesResponse syncGetServiceInstances(ServiceUpdateTask serviceUpdateTask) {
        ArrayList<DefaultInstance> instanceList = new ArrayList<DefaultInstance>();
        try {
            String namespace = serviceUpdateTask.getServiceEventKey().getNamespace();
            NamingService namingService = this.getOrCreateNamingService(namespace);
            NacosServiceMerger merger = this.mergers.get(namespace);
            if (namingService == null || merger == null) {
                LOG.error("[Connector][Nacos] fail to lookup namingService for service {}", (Object)namespace);
                return null;
            }
            NacosServiceMerger.NacosService serviceValue = merger.createIfAbsent(serviceUpdateTask.getServiceEventKey().getServiceKey());
            for (Instance service : serviceValue.getInstances()) {
                DefaultInstance instance = new DefaultInstance();
                instance.setId(service.getInstanceId());
                instance.setService(service.getServiceName());
                instance.setHost(service.getIp());
                instance.setPort(service.getPort());
                instance.setHealthy(service.isHealthy());
                instance.setMetadata((Map)Optional.ofNullable(service.getMetadata()).orElse(new HashMap()));
                instance.setIsolated(!service.isEnabled());
                instance.setWeight((int)(100.0 * service.getWeight()));
                String protocol = instance.getMetadata().getOrDefault("protocol", "");
                String version = instance.getMetadata().getOrDefault("version", "");
                if (StringUtils.isNotEmpty((String)protocol)) {
                    instance.setProtocol(protocol);
                }
                if (StringUtils.isNotEmpty((String)version)) {
                    instance.setVersion(version);
                }
                String region = instance.getMetadata().getOrDefault("region", "");
                String zone = instance.getMetadata().getOrDefault("zone", "");
                String campus = instance.getMetadata().getOrDefault("campus", "");
                if (StringUtils.isNotEmpty((String)region)) {
                    instance.setRegion(region);
                }
                if (StringUtils.isNotEmpty((String)zone)) {
                    instance.setRegion(zone);
                }
                if (StringUtils.isNotEmpty((String)campus)) {
                    instance.setRegion(campus);
                }
                instanceList.add(instance);
            }
            return new ServiceInstancesResponse(serviceValue.getRevision(), instanceList);
        }
        catch (Exception e) {
            throw ServerErrorResponseException.build((int)ErrorCode.SERVER_USER_ERROR.ordinal(), (String)String.format("[Connector][Nacos] Get service instances of %s sync failed.", serviceUpdateTask.getServiceEventKey().getServiceKey()));
        }
    }

    public Services syncGetServices(ServiceUpdateTask serviceUpdateTask) {
        ServicesByProto services = new ServicesByProto(new ArrayList());
        try {
            String namespace = serviceUpdateTask.getServiceEventKey().getNamespace();
            NamingService namingService = this.getOrCreateNamingService(namespace);
            if (namingService == null) {
                LOG.error("[Connector][Nacos] fail to lookup namingService for service {}", (Object)namespace);
                return null;
            }
            int pageIndex = 1;
            ListView listView = namingService.getServicesOfServer(pageIndex, 10, "DEFAULT_GROUP");
            LinkedHashSet serviceNames = new LinkedHashSet(listView.getData());
            int count = listView.getCount();
            int pageNumbers = count / 10;
            int remainder = count % 10;
            if (remainder > 0) {
                ++pageNumbers;
            }
            while (pageIndex < pageNumbers) {
                listView = namingService.getServicesOfServer(++pageIndex, 10, "DEFAULT_GROUP");
                serviceNames.addAll(listView.getData());
            }
            serviceNames.forEach(arg_0 -> NacosConnector.lambda$syncGetServices$0(namespace, (Services)services, arg_0));
        }
        catch (NacosException e) {
            throw ServerErrorResponseException.build((int)ErrorCode.SERVER_USER_ERROR.ordinal(), (String)String.format("[Connector][Nacos] Get services of %s instances sync failed.", serviceUpdateTask.getServiceEventKey().getServiceKey()));
        }
        return services;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRegisterEnable() {
        return this.isRegisterEnable;
    }

    public boolean isDiscoveryEnable() {
        return this.isDiscoveryEnable;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void retryServiceUpdateTask(ServiceUpdateTask updateTask) {
    }

    protected void submitServiceHandler(ServiceUpdateTask updateTask, long delayMs) {
    }

    public void addLongRunningTask(ServiceUpdateTask serviceUpdateTask) {
    }

    protected void doDestroy() {
        if (this.initialized.compareAndSet(true, false)) {
            if (CollectionUtils.isNotEmpty(this.mergers)) {
                this.mergers.forEach((s, serviceMerger) -> {
                    try {
                        serviceMerger.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(this.namingServices)) {
                this.namingServices.forEach((s, namingService) -> {
                    try {
                        namingService.shutDown();
                    }
                    catch (NacosException nacosException) {
                        // empty catch block
                    }
                });
            }
        }
    }

    private Instance buildRegisterNacosInstance(CommonProviderRequest req, String group) {
        String instanceId = String.format(INSTANCE_NAME, req.getNamespace(), group, NacosConnector.analyzeNacosService(req.getService()), req.getHost(), req.getPort());
        Instance instance = new Instance();
        instance.setInstanceId(instanceId);
        instance.setEnabled(true);
        instance.setEphemeral(true);
        instance.setPort(req.getPort());
        instance.setIp(req.getHost());
        instance.setHealthy(true);
        if (Objects.nonNull(req.getWeight())) {
            instance.setWeight((double)req.getWeight().intValue());
        }
        instance.setServiceName(NacosConnector.analyzeNacosService(req.getService()));
        if (CollectionUtils.isNotEmpty((Map)req.getMetadata()) && req.getMetadata().containsKey("nacos.cluster")) {
            instance.setClusterName((String)req.getMetadata().get("nacos.cluster"));
        }
        HashMap<String, String> metadata = new HashMap<String, String>(Optional.ofNullable(req.getMetadata()).orElse(Collections.emptyMap()));
        if (StringUtils.isNotEmpty((String)req.getProtocol())) {
            metadata.put("protocol", req.getProtocol());
        }
        if (StringUtils.isNotEmpty((String)req.getVersion())) {
            metadata.put("version", req.getVersion());
        }
        if (StringUtils.isNotEmpty((String)req.getRegion())) {
            metadata.put("region", req.getRegion());
        }
        if (StringUtils.isNotEmpty((String)req.getZone())) {
            metadata.put("zone", req.getZone());
        }
        if (StringUtils.isNotEmpty((String)req.getCampus())) {
            metadata.put("campus", req.getCampus());
        }
        instance.setMetadata(metadata);
        return instance;
    }

    private Instance buildDeregisterNacosInstance(CommonProviderRequest req, String group) {
        String instanceId = String.format(INSTANCE_NAME, req.getNamespace(), group, NacosConnector.analyzeNacosService(req.getService()), req.getHost(), req.getPort());
        Instance instance = new Instance();
        instance.setInstanceId(instanceId);
        instance.setEnabled(true);
        instance.setEphemeral(true);
        instance.setPort(req.getPort());
        instance.setIp(req.getHost());
        instance.setHealthy(true);
        if (CollectionUtils.isNotEmpty((Map)req.getMetadata()) && req.getMetadata().containsKey("nacos.cluster")) {
            instance.setClusterName((String)req.getMetadata().get("nacos.cluster"));
        }
        return instance;
    }

    protected static String analyzeNacosService(String service) {
        String[] detail = service.split("__");
        if (detail.length == 1) {
            return service;
        }
        return service.replaceFirst(detail[0] + "__", "");
    }

    protected static String analyzeNacosGroup(String service) {
        String[] detail = service.split("__");
        if (detail.length == 1 || Objects.equals(detail[0], "")) {
            return "DEFAULT_GROUP";
        }
        return detail[0];
    }

    private static /* synthetic */ void lambda$syncGetServices$0(String namespace, Services services, String name) {
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setNamespace(namespace);
        serviceInfo.setService(name);
        services.getServices().add(serviceInfo);
    }

    private static class NacosServiceMerger {
        private final NamingService namingService;
        private final Map<ServiceKey, NacosService> services = new ConcurrentHashMap<ServiceKey, NacosService>(8);

        private NacosServiceMerger(NamingService service) {
            this.namingService = service;
        }

        public void shutdown() {
            try {
                this.services.values().forEach(entry -> {
                    try {
                        this.namingService.unsubscribe(((NacosService)entry).serviceName, ((NacosService)entry).group, (EventListener)entry);
                    }
                    catch (NacosException nacosException) {
                        // empty catch block
                    }
                });
                this.services.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized NacosService createIfAbsent(ServiceKey key) throws Exception {
            if (!this.services.containsKey(key)) {
                NacosService service = new NacosService(this.namingService, NacosConnector.analyzeNacosService(key.getService()), NacosConnector.analyzeNacosGroup(key.getService()));
                service.init();
                this.services.put(key, service);
            }
            return this.services.get(key);
        }

        private static class NacosService
        implements EventListener {
            private final String serviceName;
            private final String group;
            private String revision;
            private List<Instance> instances;
            private final NamingService namingService;

            NacosService(NamingService namingService, String serviceName, String group) {
                this.namingService = namingService;
                this.serviceName = serviceName;
                this.group = group;
            }

            private void init() throws Exception {
                this.instances = this.namingService.getAllInstances(this.serviceName, this.group);
                try {
                    this.namingService.subscribe(this.serviceName, this.group, (EventListener)this);
                }
                catch (NacosException e) {
                    LOG.warn("[Connector][Nacos] service subscribe failed, service name: {}, group: {}", new Object[]{this.serviceName, this.group, e});
                }
            }

            private String buildRevision(List<Instance> instances) throws Exception {
                StringBuilder revisionStr = new StringBuilder("NacosServiceInstances");
                for (Instance instance : instances) {
                    revisionStr.append("|").append(instance.toString());
                }
                return MD5Utils.md5Hex((byte[])revisionStr.toString().getBytes(StandardCharsets.UTF_8));
            }

            public void rebuild(List<Instance> instances) throws Exception {
                this.instances = instances;
                this.revision = this.buildRevision(instances);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                NacosService that = (NacosService)o;
                return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.group, that.group);
            }

            public int hashCode() {
                return Objects.hash(this.serviceName, this.group);
            }

            public void onEvent(Event event) {
                if (event instanceof NamingEvent) {
                    NamingEvent namingEvent = (NamingEvent)event;
                    try {
                        this.rebuild(namingEvent.getInstances());
                    }
                    catch (Exception e) {
                        LOG.warn("[Connector][Nacos] service revision build failed, service name: {}, group: {}", new Object[]{this.serviceName, this.group, e});
                    }
                }
            }

            List<Instance> getInstances() {
                return this.instances;
            }

            String getRevision() {
                return this.revision;
            }
        }
    }
}

