/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.grpc.ConnectionManager;
import io.grpc.ManagedChannel;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class Connection {
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private final ConnID connID;
    private final ManagedChannel channel;
    private final ConnectionManager connectionManager;
    private final long createTimeMs;
    private final AtomicInteger ref = new AtomicInteger(0);
    private final AtomicBoolean lazyDestroy = new AtomicBoolean(false);
    private final Object lock = new Object();
    private boolean closed;

    public Connection(ManagedChannel channel, ConnID connID, ConnectionManager connectionManager) {
        this.connID = connID;
        this.channel = channel;
        this.createTimeMs = System.currentTimeMillis();
        this.connectionManager = connectionManager;
    }

    public static boolean isAvailableConnection(Connection connection) {
        if (null == connection) {
            return false;
        }
        return !connection.lazyDestroy.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(String opKey) {
        if (this.lazyDestroy.get()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.lazyDestroy.get()) {
                return false;
            }
            int curRef = this.ref.incrementAndGet();
            LOG.debug("connection {}: acquired for op {}, curRef is {}", new Object[]{this.connID, opKey, curRef});
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ref.get() <= 0 && !this.closed) {
                LOG.info("connection {}: closed", (Object)this.connID);
                this.closed = true;
                ManagedChannel shutdownChan = this.channel.shutdownNow();
                if (null == shutdownChan) {
                    return;
                }
                try {
                    shutdownChan.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOG.error(String.format("interrupted while closing connection %s", this.connID), (Throwable)e);
                }
            }
        }
    }

    public void lazyClose() {
        this.lazyDestroy.set(true);
        int curRef = this.ref.get();
        LOG.info("connection {}: lazyClose, curRef is {}", (Object)this.connID, (Object)curRef);
        if (curRef <= 0) {
            this.closeConnection();
        }
    }

    public void release(String opKey) {
        int nextValue = this.ref.decrementAndGet();
        LOG.debug("connection {}: pending to release for op {}, curRef is {}", new Object[]{this.connID, opKey, nextValue});
        if (nextValue == 0 && this.lazyDestroy.get()) {
            this.closeConnection();
        }
    }

    public void reportFail(ErrorCode errorCode) {
        if (!Objects.equals(ErrorCode.NETWORK_ERROR, errorCode)) {
            return;
        }
        this.connectionManager.reportFailConnection(this.connID);
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public long getCreateTimeMs() {
        return this.createTimeMs;
    }

    public ConnID getConnID() {
        return this.connID;
    }

    public static class ConnID {
        private final String id = UUID.randomUUID().toString();
        private final ServiceKey serviceKey;
        private final ClusterType clusterType;
        private final String host;
        private final int port;
        private final String protocol;

        public ConnID(ServiceKey serviceKey, ClusterType clusterType, String host, int port, String protocol) {
            this.serviceKey = null != serviceKey ? serviceKey : new ServiceKey("Polaris", "polaris.builtin");
            this.clusterType = clusterType;
            this.host = host;
            this.port = port;
            this.protocol = protocol;
        }

        public String getId() {
            return this.id;
        }

        public ServiceKey getServiceKey() {
            return this.serviceKey;
        }

        public ClusterType getClusterType() {
            return this.clusterType;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnID)) {
                return false;
            }
            ConnID connID = (ConnID)o;
            return this.port == connID.port && Objects.equals(this.id, connID.id) && Objects.equals(this.serviceKey, connID.serviceKey) && this.clusterType == connID.clusterType && Objects.equals(this.host, connID.host) && Objects.equals(this.protocol, connID.protocol);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.serviceKey, this.clusterType, this.host, this.port, this.protocol);
        }

        public String toString() {
            return "ConnID{id='" + this.id + '\'' + ", clusterType=" + this.clusterType + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

