/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.StringValue;
import com.google.protobuf.TextFormat;
import com.tencent.polaris.annonation.JustForTest;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.ServerCodes;
import com.tencent.polaris.api.exception.ServerErrorResponseException;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import com.tencent.polaris.plugins.connector.grpc.Connection;
import com.tencent.polaris.plugins.connector.grpc.GrpcUtil;
import com.tencent.polaris.specification.api.v1.service.manage.PolarisGRPCGrpc;
import com.tencent.polaris.specification.api.v1.service.manage.RequestProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class SpecStreamClient
implements StreamObserver<ResponseProto.DiscoverResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(SpecStreamClient.class);
    private final Object clientLock = new Object();
    private final Map<ServiceEventKey, SpecTask> pendingTask = new HashMap<ServiceEventKey, SpecTask>();
    private final AtomicBoolean endStream = new AtomicBoolean(false);
    private final StreamObserver<RequestProto.DiscoverRequest> discoverClient;
    private final Connection connection;
    private final String reqId;
    private final AtomicLong lastRecvTimeMs = new AtomicLong(0L);
    private final long createTimeMs;
    private final long connectionIdleTimeoutMs;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("clean-expire-pendingtask"));
    private static long PENDING_TASK_EXPIRE_MS = 30000L;

    public SpecStreamClient(Connection connection, long connectionIdleTimeoutMs, ServiceUpdateTask serviceUpdateTask) {
        this.connection = connection;
        this.connectionIdleTimeoutMs = connectionIdleTimeoutMs;
        this.createTimeMs = System.currentTimeMillis();
        this.reqId = GrpcUtil.nextGetInstanceReqId();
        PolarisGRPCGrpc.PolarisGRPCStub namingStub = PolarisGRPCGrpc.newStub((Channel)connection.getChannel());
        GrpcUtil.attachRequestHeader(namingStub, this.reqId);
        this.discoverClient = namingStub.discover((StreamObserver)this);
        this.putPendingTask(serviceUpdateTask);
        this.executor.schedule(new ExpirePendingTaskCleaner(this, PENDING_TASK_EXPIRE_MS), 5L, TimeUnit.SECONDS);
    }

    @JustForTest
    public SpecStreamClient(long pendingTaskExpireMs) {
        this.connection = null;
        this.connectionIdleTimeoutMs = 0L;
        this.createTimeMs = System.currentTimeMillis();
        this.discoverClient = null;
        this.reqId = UUID.randomUUID().toString();
        this.executor.schedule(new ExpirePendingTaskCleaner(this, pendingTaskExpireMs), 5L, TimeUnit.SECONDS);
    }

    public void closeStream(boolean closeSend) {
        this.executor.shutdownNow();
        boolean endStreamOK = this.endStream.compareAndSet(false, true);
        if (!endStreamOK) {
            return;
        }
        if (closeSend) {
            LOG.info("[ServerConnector]connection {} start to closeSend", (Object)this.connection.getConnID());
            this.discoverClient.onCompleted();
        }
        this.connection.release("Discover");
    }

    private boolean isEndStream() {
        return this.endStream.get();
    }

    public String getReqId() {
        return this.reqId;
    }

    public void sendRequest(ServiceUpdateTask serviceUpdateTask) {
        ServiceEventKey serviceEventKey = serviceUpdateTask.getServiceEventKey();
        ServiceProto.Service.Builder builder = ServiceProto.Service.newBuilder();
        builder.setName(StringValue.newBuilder().setValue(serviceEventKey.getServiceKey().getService()).build());
        builder.setNamespace(StringValue.newBuilder().setValue(serviceEventKey.getServiceKey().getNamespace()).build());
        builder.setRevision(StringValue.newBuilder().setValue(serviceUpdateTask.getEventHandler().getRevision()).build());
        RequestProto.DiscoverRequest.Builder req = RequestProto.DiscoverRequest.newBuilder();
        req.setType(GrpcUtil.buildDiscoverRequestType(serviceEventKey.getEventType()));
        req.setService(builder);
        if (serviceUpdateTask.getTaskType() == ServiceUpdateTaskConstant.Type.FIRST) {
            LOG.info("[ServerConnector]send request(id={}) to {} for service {}", new Object[]{this.reqId, this.connection.getConnID(), serviceEventKey});
        } else {
            LOG.debug("[ServerConnector]send request(id={}) to {} for service {}", new Object[]{this.reqId, this.connection.getConnID(), serviceEventKey});
        }
        this.discoverClient.onNext((Object)req.build());
    }

    private ValidResult validMessage(ResponseProto.DiscoverResponse response) {
        ErrorCode errorCode = ErrorCode.Success;
        if (response.hasCode()) {
            errorCode = ServerCodes.convertServerErrorToRpcError((int)response.getCode().getValue());
        }
        ServiceProto.Service service = response.getService();
        ServiceEventKey.EventType eventType = GrpcUtil.buildEventType(response.getType());
        if (!eventType.equals((Object)ServiceEventKey.EventType.SERVICE) && (StringUtils.isEmpty((String)service.getNamespace().getValue()) || StringUtils.isEmpty((String)service.getName().getValue()))) {
            return new ValidResult(null, ErrorCode.INVALID_SERVER_RESPONSE, "service is empty, response text is " + response.toString());
        }
        if (eventType == ServiceEventKey.EventType.UNKNOWN) {
            return new ValidResult(null, ErrorCode.INVALID_SERVER_RESPONSE, "invalid event type " + response.getType());
        }
        ServiceEventKey serviceEventKey = new ServiceEventKey(new ServiceKey(service.getNamespace().getValue(), service.getName().getValue()), eventType);
        if (errorCode == ErrorCode.SERVER_ERROR) {
            return new ValidResult(serviceEventKey, errorCode, "invalid event type " + response.getType());
        }
        return new ValidResult(serviceEventKey, ErrorCode.Success, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCallback(ValidResult validResult) {
        this.closeStream(false);
        if (validResult.getMessage().contains("EOF")) {
            LOG.debug("[ServerConnector]exceptionCallback: errCode {}, info {}, serviceEventKey {}", new Object[]{validResult.getErrorCode(), validResult.getMessage(), validResult.getServiceEventKey()});
        } else {
            LOG.error("[ServerConnector]exceptionCallback: errCode {}, info {}, serviceEventKey {}", new Object[]{validResult.getErrorCode(), validResult.getMessage(), validResult.getServiceEventKey()});
        }
        this.connection.reportFail(validResult.getErrorCode());
        ArrayList<ServiceUpdateTask> notifyTasks = new ArrayList<ServiceUpdateTask>();
        Iterator iterator = this.clientLock;
        synchronized (iterator) {
            ServiceEventKey serviceEventKey = validResult.getServiceEventKey();
            if (null == serviceEventKey) {
                if (CollectionUtils.isNotEmpty(this.pendingTask.values())) {
                    notifyTasks.addAll(this.listPendingTasks());
                    for (SpecTask value : this.pendingTask.values()) {
                        ServiceUpdateTask task = value.task;
                        ServerErrorResponseException error = ServerErrorResponseException.build((int)ErrorCode.NETWORK_ERROR.getCode(), (String)String.format("[ServerConnector]code %s, fail to query service %s from server(%s): %s", validResult.getErrorCode(), task.getServiceEventKey(), this.connection.getConnID(), validResult.getMessage()));
                        task.notifyServerEvent(new ServerEvent(task.getServiceEventKey(), null, (PolarisException)error));
                    }
                    this.pendingTask.clear();
                }
            } else {
                ServiceUpdateTask task = this.removePendingTask(serviceEventKey);
                if (null != task) {
                    notifyTasks.add(task);
                    ServerErrorResponseException error = ServerErrorResponseException.build((int)ErrorCode.NETWORK_ERROR.getCode(), (String)String.format("[ServerConnector]code %s, fail to query service %s from server(%s): %s", validResult.getErrorCode(), task.getServiceEventKey(), this.connection.getConnID(), validResult.getMessage()));
                    task.notifyServerEvent(new ServerEvent(task.getServiceEventKey(), null, (PolarisException)error));
                }
            }
        }
        for (ServiceUpdateTask notifyTask : notifyTasks) {
            notifyTask.retry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(ResponseProto.DiscoverResponse response) {
        ServiceUpdateTask updateTask;
        this.lastRecvTimeMs.set(System.currentTimeMillis());
        ValidResult validResult = this.validMessage(response);
        if (validResult.errorCode != ErrorCode.Success) {
            this.exceptionCallback(validResult);
            return;
        }
        ServiceProto.Service service = response.getService();
        ServiceKey serviceKey = new ServiceKey(service.getNamespace().getValue(), service.getName().getValue());
        ServiceEventKey.EventType eventType = GrpcUtil.buildEventType(response.getType());
        ServiceEventKey serviceEventKey = new ServiceEventKey(serviceKey, eventType);
        Object object = this.clientLock;
        synchronized (object) {
            updateTask = this.removePendingTask(serviceEventKey);
        }
        if (null == updateTask) {
            LOG.warn("[ServerConnector]callback not found for:{}", (Object)TextFormat.shortDebugString((MessageOrBuilder)service));
            return;
        }
        if (updateTask.getTaskType() == ServiceUpdateTaskConstant.Type.FIRST) {
            LOG.info("[ServerConnector]request(id={}) receive response for {}", (Object)this.getReqId(), (Object)serviceEventKey);
        } else {
            LOG.debug("[ServerConnector]request(id={}) receive response for {}", (Object)this.getReqId(), (Object)serviceEventKey);
        }
        boolean svcDeleted = updateTask.notifyServerEvent(new ServerEvent(serviceEventKey, (Object)response, null));
        if (!svcDeleted) {
            updateTask.addUpdateTaskSet();
        }
    }

    public void onError(Throwable throwable) {
        this.exceptionCallback(new ValidResult(null, ErrorCode.NETWORK_ERROR, String.format("stream %s received error from server(%s), error is %s", this.getReqId(), this.connection.getConnID().toString(), throwable.getMessage())));
    }

    public void onCompleted() {
        this.exceptionCallback(new ValidResult(null, ErrorCode.NETWORK_ERROR, String.format("stream %s EOF by server(%s)", this.getReqId(), this.connection.getConnID().toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseExpireStream() {
        Object object = this.clientLock;
        synchronized (object) {
            this.closeExpireStream();
        }
    }

    private boolean closeExpireStream() {
        long lastRecvMs = this.lastRecvTimeMs.get();
        long nowMs = System.currentTimeMillis();
        long connIdleTime = lastRecvMs == 0L ? nowMs - this.createTimeMs : nowMs - lastRecvMs;
        if (connIdleTime >= this.connectionIdleTimeoutMs) {
            this.closeStream(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAvailable(ServiceUpdateTask serviceUpdateTask) {
        if (this.isEndStream()) {
            return false;
        }
        if (!Connection.isAvailableConnection(this.connection)) {
            return false;
        }
        Object object = this.clientLock;
        synchronized (object) {
            if (this.isEndStream()) {
                return false;
            }
            if (this.closeExpireStream()) {
                return false;
            }
            ServiceEventKey serviceEventKey = serviceUpdateTask.getServiceEventKey();
            SpecTask lastUpdateTask = this.pendingTask.get(serviceEventKey);
            if (null != lastUpdateTask) {
                LOG.warn("[ServerConnector]pending task {} has been overwritten", (Object)lastUpdateTask);
            }
            this.putPendingTask(serviceUpdateTask);
        }
        return true;
    }

    private List<ServiceUpdateTask> listPendingTasks() {
        return this.pendingTask.values().stream().map(specTask -> ((SpecTask)specTask).task).collect(Collectors.toList());
    }

    public void putPendingTask(ServiceUpdateTask serviceUpdateTask) {
        LOG.debug("Put " + serviceUpdateTask.getServiceEventKey() + "to pending task map. reqId: " + this.reqId);
        this.pendingTask.put(serviceUpdateTask.getServiceEventKey(), new SpecTask(serviceUpdateTask));
    }

    public ServiceUpdateTask removePendingTask(ServiceEventKey serviceEventKey) {
        LOG.debug("Remove " + serviceEventKey + "from pending task map. reqId: " + this.reqId);
        SpecTask task = this.pendingTask.remove(serviceEventKey);
        if (Objects.isNull(task)) {
            return null;
        }
        return task.task;
    }

    private static class ExpirePendingTaskCleaner
    implements Runnable {
        private final SpecStreamClient client;
        private final long pendingTaskExpireMs;

        private ExpirePendingTaskCleaner(SpecStreamClient client, long pendingTaskExpireMs) {
            this.client = client;
            this.pendingTaskExpireMs = pendingTaskExpireMs;
        }

        @Override
        public void run() {
            try {
                this.realCheck();
            }
            finally {
                this.client.executor.schedule(this, 5L, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void realCheck() {
            long current = System.currentTimeMillis();
            Object object = this.client.clientLock;
            synchronized (object) {
                HashMap waitRetry = new HashMap();
                for (Map.Entry entry : this.client.pendingTask.entrySet()) {
                    SpecTask specTask = (SpecTask)entry.getValue();
                    if (current - specTask.submitTimeMs <= this.pendingTaskExpireMs) continue;
                    waitRetry.put(entry.getKey(), specTask.task);
                }
                waitRetry.forEach((serviceEventKey, serviceUpdateTask) -> {
                    LOG.info("[ServerConnector] retry pending task {}, because it's long time to running", serviceEventKey);
                    this.client.removePendingTask((ServiceEventKey)serviceEventKey);
                    serviceUpdateTask.retry();
                });
            }
        }
    }

    private static class SpecTask {
        private final ServiceUpdateTask task;
        private final long submitTimeMs;

        private SpecTask(ServiceUpdateTask task) {
            this.task = task;
            this.submitTimeMs = System.currentTimeMillis();
        }
    }

    private static class ValidResult {
        final ServiceEventKey serviceEventKey;
        final ErrorCode errorCode;
        final String message;

        public ValidResult(ServiceEventKey serviceEventKey, ErrorCode errorCode, String message) {
            this.serviceEventKey = serviceEventKey;
            this.errorCode = errorCode;
            this.message = message;
        }

        public ServiceEventKey getServiceEventKey() {
            return this.serviceEventKey;
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

