/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.server.EventHandler;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.plugins.connector.grpc.Connection;
import com.tencent.polaris.plugins.connector.grpc.ConnectionManager;
import com.tencent.polaris.plugins.connector.grpc.GrpcConnector;
import com.tencent.polaris.plugins.connector.grpc.SpecStreamClient;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUpdateTask
implements Runnable,
Comparable<ServiceUpdateTask> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceUpdateTask.class);
    private final GrpcConnector grpcConnector;
    private final AtomicReference<Type> taskType = new AtomicReference();
    private final AtomicReference<Status> taskStatus = new AtomicReference();
    private final long refreshIntervalMs;
    private final EventHandler eventHandler;
    private final ServiceEventKey serviceEventKey;
    private final AtomicLong msgSendTime = new AtomicLong(0L);
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicLong totalRequests = new AtomicLong(0L);
    private final AtomicLong successUpdates = new AtomicLong(0L);
    private final AtomicReference<ClusterType> targetClusterType = new AtomicReference();

    @Override
    public int compareTo(ServiceUpdateTask o) {
        return this.taskType.get().ordinal() - o.taskType.get().ordinal();
    }

    public ServiceUpdateTask(ServiceEventHandler handler, GrpcConnector connector) {
        this.grpcConnector = connector;
        this.serviceEventKey = handler.getServiceEventKey();
        this.refreshIntervalMs = handler.getRefreshIntervalMs() + (long)new Random().nextInt(1000);
        this.eventHandler = handler.getEventHandler();
        this.taskType.set(Type.FIRST);
        this.taskStatus.set(Status.READY);
        this.targetClusterType.set(handler.getTargetCluster());
    }

    public ServiceEventKey getServiceEventKey() {
        return this.serviceEventKey;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public ClusterType getTargetClusterType() {
        return this.targetClusterType.get();
    }

    public boolean setType(Type last, Type current) {
        return this.taskType.compareAndSet(last, current);
    }

    public boolean setStatus(Status last, Status current) {
        return this.taskStatus.compareAndSet(last, current);
    }

    public Type getTaskType() {
        return this.taskType.get();
    }

    public void retry() {
        this.grpcConnector.retryServiceUpdateTask(this);
    }

    @Override
    public void run() {
        if (this.getTaskType() == Type.FIRST) {
            LOG.info("[ServerConnector]start to run first task {}", (Object)this);
        } else {
            LOG.debug("[ServerConnector]start to run task {}", (Object)this);
        }
        ConnectionManager connectionManager = this.grpcConnector.getConnectionManager();
        ClusterType clusterType = this.targetClusterType.get();
        boolean clusterReady = connectionManager.checkReady(clusterType);
        if (!clusterReady) {
            LOG.info("{} service is not ready", (Object)clusterType);
            this.grpcConnector.retryServiceUpdateTask(this);
            return;
        }
        if (this.grpcConnector.isDestroyed()) {
            LOG.info("{} grpc connection is destroyed", (Object)clusterType);
            this.grpcConnector.retryServiceUpdateTask(this);
            return;
        }
        AtomicReference<SpecStreamClient> streamClientAtomicReference = this.grpcConnector.getStreamClient(clusterType);
        SpecStreamClient specStreamClient = streamClientAtomicReference.get();
        boolean available = this.checkStreamClientAvailable(specStreamClient);
        if (!available) {
            LOG.debug("[ServerConnector]start to get connection for task {}", (Object)this);
            Connection connection = null;
            try {
                connection = connectionManager.getConnection("Discover", clusterType);
            }
            catch (PolarisException e) {
                LOG.error("[ServerConnector]fail to get connection to {}", (Object)clusterType, (Object)e);
            }
            if (null == connection) {
                LOG.error("[ServerConnector]get null connection for {}", (Object)this);
                this.grpcConnector.retryServiceUpdateTask(this);
                return;
            }
            specStreamClient = new SpecStreamClient(connection, this.grpcConnector.getConnectionIdleTimeoutMs(), this);
            streamClientAtomicReference.set(specStreamClient);
            LOG.info("[ServerConnector]success to create stream client for task {}", (Object)this);
        }
        this.msgSendTime.set(System.currentTimeMillis());
        this.totalRequests.addAndGet(1L);
        specStreamClient.sendRequest(this);
    }

    private boolean checkStreamClientAvailable(SpecStreamClient streamClient) {
        if (null == streamClient) {
            return false;
        }
        return streamClient.checkAvailable(this);
    }

    public void addUpdateTaskSet() {
        if (this.taskType.compareAndSet(Type.FIRST, Type.LONG_RUNNING)) {
            this.targetClusterType.set(ClusterType.SERVICE_DISCOVER_CLUSTER);
            this.grpcConnector.addLongRunningTask(this);
        }
    }

    public boolean needUpdate() {
        if (this.taskType.get() != Type.LONG_RUNNING || this.taskStatus.get() != Status.READY) {
            return false;
        }
        long nowMs = System.currentTimeMillis();
        return nowMs - this.lastUpdateTime.get() >= this.refreshIntervalMs;
    }

    public String toString() {
        return "ServiceUpdateTask{taskType=" + (Object)((Object)this.taskType.get()) + ", taskStatus=" + (Object)((Object)this.taskStatus.get()) + ", serviceEventKey=" + this.serviceEventKey + ", targetClusterType=" + this.targetClusterType.get() + '}';
    }

    public long getRefreshIntervalMs() {
        return this.refreshIntervalMs;
    }

    public boolean notifyServerEvent(ServerEvent serverEvent) {
        this.taskStatus.compareAndSet(Status.RUNNING, Status.READY);
        this.lastUpdateTime.set(System.currentTimeMillis());
        if (null == serverEvent.getError()) {
            this.successUpdates.addAndGet(1L);
        }
        return this.eventHandler.onEventUpdate(serverEvent);
    }

    public static enum Status {
        RUNNING,
        READY;

    }

    public static enum Type {
        FIRST,
        LONG_RUNNING,
        TERMINATED;

    }
}

