/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.StringValue;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UInt32Value;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.config.global.ServerConnectorConfig;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.server.CommonProviderRequest;
import com.tencent.polaris.api.plugin.server.CommonProviderResponse;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.pb.ClientProto;
import com.tencent.polaris.client.pb.PolarisGRPCGrpc;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pb.ServiceProto;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.plugins.connector.grpc.Connection;
import com.tencent.polaris.plugins.connector.grpc.ConnectionManager;
import com.tencent.polaris.plugins.connector.grpc.GrpcUtil;
import com.tencent.polaris.plugins.connector.grpc.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.grpc.SpecStreamClient;
import io.grpc.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcConnector
extends Destroyable
implements ServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcConnector.class);
    private static final int TASK_RETRY_INTERVAL_MS = 500;
    private long messageTimeoutMs;
    private ConnectionManager connectionManager;
    private final Map<ServiceEventKey, ServiceUpdateTask> updateTaskSet = new ConcurrentHashMap<ServiceEventKey, ServiceUpdateTask>();
    private final Map<ClusterType, AtomicReference<SpecStreamClient>> streamClients = new HashMap<ClusterType, AtomicReference<SpecStreamClient>>();
    private long connectionIdleTimeoutMs;
    private ScheduledThreadPoolExecutor sendDiscoverExecutor;
    private ScheduledThreadPoolExecutor buildInExecutor;
    private ScheduledThreadPoolExecutor updateServiceExecutor;
    private CompletableFuture<String> readyFuture;

    public void init(InitContext ctx) throws PolarisException {
        this.readyFuture = new CompletableFuture();
        HashMap<ClusterType, CompletableFuture<String>> futures = new HashMap<ClusterType, CompletableFuture<String>>();
        futures.put(ClusterType.SERVICE_DISCOVER_CLUSTER, this.readyFuture);
        this.connectionManager = new ConnectionManager(ctx, futures);
        Configuration config = ctx.getConfig();
        ServerConnectorConfig connectorConfig = config.getGlobal().getServerConnector();
        this.connectionIdleTimeoutMs = connectorConfig.getConnectionIdleTimeout();
        this.messageTimeoutMs = connectorConfig.getMessageTimeout();
        this.sendDiscoverExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory(this.getName() + "-send-discovery"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.sendDiscoverExecutor.setMaximumPoolSize(1);
        this.buildInExecutor = new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory(this.getName() + "-builtin-discovery"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.buildInExecutor.setMaximumPoolSize(1);
        this.streamClients.put(ClusterType.BUILTIN_CLUSTER, new AtomicReference());
        this.streamClients.put(ClusterType.SERVICE_DISCOVER_CLUSTER, new AtomicReference());
        this.updateServiceExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory(this.getName() + "-update-service"));
        this.updateServiceExecutor.setMaximumPoolSize(1);
    }

    private void waitDiscoverReady() {
        try {
            this.readyFuture.get(this.messageTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            throw new RetriableException(ErrorCode.API_TIMEOUT, "discover service not ready");
        }
    }

    public void registerServiceHandler(ServiceEventHandler handler) {
        this.checkDestroyed();
        ServiceUpdateTask serviceUpdateTask = new ServiceUpdateTask(handler, this);
        this.submitServiceHandler(serviceUpdateTask, 0L);
    }

    public void retryServiceUpdateTask(ServiceUpdateTask updateTask) {
        LOG.info("[ServerConnector]retry schedule task for {}, retry delay {}", (Object)updateTask, (Object)500);
        updateTask.setStatus(ServiceUpdateTask.Status.RUNNING, ServiceUpdateTask.Status.READY);
        if (this.isDestroyed()) {
            return;
        }
        this.submitServiceHandler(updateTask, 500L);
    }

    private void submitServiceHandler(ServiceUpdateTask updateTask, long delayMs) {
        ClusterType targetCluster = updateTask.getTargetClusterType();
        if (updateTask.setStatus(ServiceUpdateTask.Status.READY, ServiceUpdateTask.Status.RUNNING)) {
            if (targetCluster == ClusterType.BUILTIN_CLUSTER) {
                LOG.info("[ServerConnector]task for service {} has been scheduled builtin", (Object)updateTask);
                this.buildInExecutor.schedule(updateTask, delayMs, TimeUnit.MILLISECONDS);
            } else {
                LOG.debug("[ServerConnector]task for service {} has been scheduled discover", (Object)updateTask);
                this.sendDiscoverExecutor.schedule(updateTask, delayMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void deRegisterServiceHandler(ServiceEventKey eventKey) throws PolarisException {
        this.checkDestroyed();
        ServiceUpdateTask serviceUpdateTask = this.updateTaskSet.get(eventKey);
        if (null != serviceUpdateTask) {
            boolean result = serviceUpdateTask.setType(ServiceUpdateTask.Type.LONG_RUNNING, ServiceUpdateTask.Type.TERMINATED);
            LOG.info("[ServerConnector]success to deRegister updateServiceTask {}, result is {}", (Object)eventKey, (Object)result);
        }
    }

    public CommonProviderResponse registerInstance(CommonProviderRequest req) throws PolarisException {
        this.checkDestroyed();
        ServiceKey serviceKey = new ServiceKey(req.getNamespace(), req.getService());
        Connection connection = null;
        try {
            this.waitDiscoverReady();
            connection = this.connectionManager.getConnection("RegisterInstance", ClusterType.SERVICE_DISCOVER_CLUSTER);
            PolarisGRPCGrpc.PolarisGRPCBlockingStub stub = PolarisGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader(stub, GrpcUtil.nextInstanceRegisterReqId());
            ResponseProto.Response registerInstanceResponse = stub.registerInstance(this.buildRegisterInstanceRequest(req));
            GrpcUtil.checkResponse(registerInstanceResponse);
            if (!registerInstanceResponse.hasInstance()) {
                throw new PolarisException(ErrorCode.SERVER_USER_ERROR, "invalid register response: missing instance");
            }
            CommonProviderResponse resp = new CommonProviderResponse();
            resp.setInstanceID(registerInstanceResponse.getInstance().getId().getValue());
            resp.setExists(registerInstanceResponse.getCode().getValue() == 400201);
            CommonProviderResponse commonProviderResponse = resp;
            return commonProviderResponse;
        }
        catch (Throwable t) {
            if (t instanceof PolarisException) {
                throw t;
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("fail to register host %s:%d service %s", req.getHost(), req.getPort(), serviceKey), t);
        }
        finally {
            if (null != connection) {
                connection.release("RegisterInstance");
            }
        }
    }

    private ServiceProto.Instance buildRegisterInstanceRequest(CommonProviderRequest req) {
        ServiceProto.Instance.Builder instanceBuilder = ServiceProto.Instance.newBuilder();
        instanceBuilder.setService(StringValue.newBuilder().setValue(req.getService()).build());
        instanceBuilder.setNamespace(StringValue.newBuilder().setValue(req.getNamespace()).build());
        if (StringUtils.isNotBlank((String)req.getToken())) {
            instanceBuilder.setServiceToken(StringValue.newBuilder().setValue(req.getToken()).build());
        }
        instanceBuilder.setHost(StringValue.newBuilder().setValue(req.getHost()).build());
        instanceBuilder.setPort(UInt32Value.newBuilder().setValue(req.getPort()).build());
        if (StringUtils.isNotBlank((String)req.getProtocol())) {
            instanceBuilder.setProtocol(StringValue.newBuilder().setValue(req.getProtocol()).build());
        }
        if (StringUtils.isNotBlank((String)req.getVersion())) {
            instanceBuilder.setVersion(StringValue.newBuilder().setValue(req.getVersion()).build());
        }
        if (null != req.getWeight()) {
            instanceBuilder.setWeight(UInt32Value.newBuilder().setValue(req.getWeight().intValue()).build());
        }
        if (null != req.getPriority()) {
            instanceBuilder.setPriority(UInt32Value.newBuilder().setValue(req.getPriority().intValue()).build());
        }
        if (null != req.getMetadata()) {
            instanceBuilder.putAllMetadata(req.getMetadata());
        }
        if (null != req.getTtl()) {
            ServiceProto.HealthCheck.Builder healthCheckBuilder = ServiceProto.HealthCheck.newBuilder();
            healthCheckBuilder.setType(ServiceProto.HealthCheck.HealthCheckType.HEARTBEAT);
            healthCheckBuilder.setHeartbeat(ServiceProto.HeartbeatHealthCheck.newBuilder().setTtl(UInt32Value.newBuilder().setValue(req.getTtl().intValue()).build()).build());
            instanceBuilder.setHealthCheck(healthCheckBuilder.build());
        }
        return instanceBuilder.build();
    }

    private ServiceProto.Instance buildHeartbeatRequest(CommonProviderRequest req) {
        ServiceProto.Instance.Builder instanceBuilder = ServiceProto.Instance.newBuilder();
        if (StringUtils.isNotBlank((String)req.getInstanceID())) {
            instanceBuilder.setId(StringValue.newBuilder().setValue(req.getInstanceID()).build());
        }
        if (StringUtils.isNotBlank((String)req.getService())) {
            instanceBuilder.setService(StringValue.newBuilder().setValue(req.getService()).build());
        }
        if (StringUtils.isNotBlank((String)req.getHost())) {
            instanceBuilder.setHost(StringValue.newBuilder().setValue(req.getHost()).build());
        }
        if (StringUtils.isNotBlank((String)req.getNamespace())) {
            instanceBuilder.setNamespace(StringValue.newBuilder().setValue(req.getNamespace()).build());
        }
        if (req.getPort() > 0) {
            instanceBuilder.setPort(UInt32Value.of((int)req.getPort()));
        }
        if (StringUtils.isNotBlank((String)req.getToken())) {
            instanceBuilder.setServiceToken(StringValue.newBuilder().setValue(req.getToken()).build());
        }
        return instanceBuilder.build();
    }

    private ClientProto.Client buildReportRequest(ReportClientRequest req) {
        return ClientProto.Client.newBuilder().setHost(StringValue.newBuilder().setValue(req.getClientHost())).setVersion(StringValue.newBuilder().setValue(req.getVersion())).build();
    }

    private ServiceProto.Instance buildDeregisterInstanceRequest(CommonProviderRequest req) {
        ServiceProto.Instance.Builder instanceBuilder = ServiceProto.Instance.newBuilder();
        if (StringUtils.isNotBlank((String)req.getInstanceID())) {
            instanceBuilder.setId(StringValue.newBuilder().setValue(req.getInstanceID()).build());
        }
        if (StringUtils.isNotBlank((String)req.getNamespace())) {
            instanceBuilder.setNamespace(StringValue.newBuilder().setValue(req.getNamespace()).build());
        }
        if (StringUtils.isNotBlank((String)req.getService())) {
            instanceBuilder.setService(StringValue.newBuilder().setValue(req.getService()).build());
        }
        if (StringUtils.isNotBlank((String)req.getHost())) {
            instanceBuilder.setHost(StringValue.newBuilder().setValue(req.getHost()).build());
        }
        if (req.getPort() > 0) {
            instanceBuilder.setPort(UInt32Value.of((int)req.getPort()));
        }
        if (StringUtils.isNotBlank((String)req.getToken())) {
            instanceBuilder.setServiceToken(StringValue.newBuilder().setValue(req.getToken()).build());
        }
        return instanceBuilder.build();
    }

    public void deregisterInstance(CommonProviderRequest req) throws PolarisException {
        this.checkDestroyed();
        Connection connection = null;
        ServiceKey serviceKey = new ServiceKey(req.getNamespace(), req.getService());
        try {
            this.waitDiscoverReady();
            connection = this.connectionManager.getConnection("DeregisterInstance", ClusterType.SERVICE_DISCOVER_CLUSTER);
            PolarisGRPCGrpc.PolarisGRPCBlockingStub stub = PolarisGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader(stub, GrpcUtil.nextInstanceDeRegisterReqId());
            ResponseProto.Response deregisterInstanceResponse = stub.deregisterInstance(this.buildDeregisterInstanceRequest(req));
            GrpcUtil.checkResponse(deregisterInstanceResponse);
            LOG.debug("received deregister response {}", (Object)deregisterInstanceResponse);
        }
        catch (Throwable t) {
            if (t instanceof PolarisException) {
                throw t;
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("fail to deregister id %s, host %s:%d service %s", req.getInstanceID(), req.getHost(), req.getPort(), serviceKey), t);
        }
        finally {
            if (null != connection) {
                connection.release("DeregisterInstance");
            }
        }
    }

    public void heartbeat(CommonProviderRequest req) throws PolarisException {
        this.checkDestroyed();
        Connection connection = null;
        ServiceKey serviceKey = new ServiceKey(req.getNamespace(), req.getService());
        try {
            this.waitDiscoverReady();
            connection = this.connectionManager.getConnection("InstanceHeartbeat", ClusterType.HEALTH_CHECK_CLUSTER);
            PolarisGRPCGrpc.PolarisGRPCBlockingStub stub = PolarisGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
            GrpcUtil.attachRequestHeader(stub, GrpcUtil.nextHeartbeatReqId());
            ResponseProto.Response heartbeatResponse = stub.heartbeat(this.buildHeartbeatRequest(req));
            GrpcUtil.checkResponse(heartbeatResponse);
            LOG.debug("received heartbeat response {}", (Object)heartbeatResponse);
        }
        catch (Throwable t) {
            if (t instanceof PolarisException) {
                throw t;
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("fail to heartbeat id %s, host %s:%d service %s", req.getInstanceID(), req.getHost(), req.getPort(), serviceKey), t);
        }
        finally {
            if (null != connection) {
                connection.release("InstanceHeartbeat");
            }
        }
    }

    public ReportClientResponse reportClient(ReportClientRequest req) throws PolarisException {
        this.checkDestroyed();
        this.waitDiscoverReady();
        Connection connection = this.connectionManager.getConnection("ReportClient", ClusterType.SERVICE_DISCOVER_CLUSTER);
        PolarisGRPCGrpc.PolarisGRPCBlockingStub stub = PolarisGRPCGrpc.newBlockingStub((Channel)connection.getChannel());
        GrpcUtil.attachRequestHeader(stub, GrpcUtil.nextHeartbeatReqId());
        ServiceKey serviceKey = new ServiceKey(req.getNamespace(), req.getService());
        try {
            ClientProto.Client request = this.buildReportRequest(req);
            ResponseProto.Response response = stub.reportClient(request);
            LOG.debug("reportClient req:{}, rsp:{}", (Object)req, (Object)TextFormat.shortDebugString((MessageOrBuilder)response));
            GrpcUtil.checkResponse(response);
            ReportClientResponse rsp = new ReportClientResponse();
            if (null == response.getClient().getLocation()) {
                throw new IllegalStateException(String.format("unexpected null response from clientReport api, response:%s", TextFormat.shortDebugString((MessageOrBuilder)response)));
            }
            rsp.setCampus(response.getClient().getLocation().getCampus().getValue());
            rsp.setZone(response.getClient().getLocation().getZone().getValue());
            rsp.setRegion(response.getClient().getLocation().getRegion().getValue());
            ReportClientResponse reportClientResponse = rsp;
            return reportClientResponse;
        }
        catch (Throwable t) {
            if (t instanceof PolarisException) {
                throw t;
            }
            throw new RetriableException(ErrorCode.NETWORK_ERROR, String.format("fail to report client host %s, version %s service %s", req.getClientHost(), req.getVersion(), serviceKey), t);
        }
        finally {
            connection.release("ReportClient");
        }
    }

    public void updateServers(ServiceEventKey svcEventKey) {
        this.connectionManager.makeReady(svcEventKey);
    }

    public String getName() {
        return "grpc";
    }

    public PluginType getType() {
        return PluginTypes.SERVER_CONNECTOR.getBaseType();
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        this.connectionManager.setExtensions(extensions);
        this.updateServiceExecutor.scheduleWithFixedDelay(new UpdateServiceTask(), 500L, 500L, TimeUnit.MILLISECONDS);
        this.updateServiceExecutor.scheduleWithFixedDelay(new ClearIdleStreamClientTask(), this.connectionIdleTimeoutMs, this.connectionIdleTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public void doDestroy() {
        LOG.info("start to destroy connector {}", (Object)this.getName());
        ThreadPoolUtils.waitAndStopThreadPools((ExecutorService[])new ExecutorService[]{this.sendDiscoverExecutor, this.buildInExecutor, this.updateServiceExecutor});
        if (null != this.connectionManager) {
            this.connectionManager.destroy();
        }
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void addLongRunningTask(ServiceUpdateTask serviceUpdateTask) {
        this.updateTaskSet.put(serviceUpdateTask.getServiceEventKey(), serviceUpdateTask);
    }

    public AtomicReference<SpecStreamClient> getStreamClient(ClusterType clusterType) {
        return this.streamClients.get(clusterType);
    }

    public long getConnectionIdleTimeoutMs() {
        return this.connectionIdleTimeoutMs;
    }

    private class ClearIdleStreamClientTask
    implements Runnable {
        private ClearIdleStreamClientTask() {
        }

        @Override
        public void run() {
            for (AtomicReference streamClientRef : GrpcConnector.this.streamClients.values()) {
                SpecStreamClient streamClient = (SpecStreamClient)streamClientRef.get();
                if (null == streamClient) continue;
                streamClient.syncCloseExpireStream();
            }
        }
    }

    private class UpdateServiceTask
    implements Runnable {
        private UpdateServiceTask() {
        }

        @Override
        public void run() {
            for (ServiceUpdateTask serviceUpdateTask : GrpcConnector.this.updateTaskSet.values()) {
                if (GrpcConnector.this.isDestroyed()) break;
                if (!serviceUpdateTask.needUpdate()) continue;
                GrpcConnector.this.submitServiceHandler(serviceUpdateTask, 0L);
            }
        }
    }
}

