/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.tencent.polaris.api.plugin.registry.CacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pb.ServiceProto;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CommonHandler.class);
    private static final String emptyReplaceHolder = "<empty>";

    public static CacheHandler.CachedStatus compareMessage(ServiceEventKey.EventType eventType, RegistryCacheValue oldValue, ResponseProto.DiscoverResponse discoverResponse, Function<ResponseProto.DiscoverResponse, String> getRevision) {
        CacheHandler.CachedStatus cachedStatus;
        String oldRevision;
        ServiceProto.Service service = discoverResponse.getService();
        ServiceEventKey serviceEventKey = new ServiceEventKey(new ServiceKey(service.getNamespace().getValue(), service.getName().getValue()), eventType);
        if (discoverResponse.getCode().getValue() == 200001) {
            if (null == oldValue) {
                return CacheHandler.CachedStatus.CacheEmptyButNoData;
            }
            return CacheHandler.CachedStatus.CacheNotChanged;
        }
        String newRevision = getRevision.apply(discoverResponse);
        boolean oldLoadedFromFile = false;
        if (null == oldValue) {
            oldRevision = emptyReplaceHolder;
            cachedStatus = CacheHandler.CachedStatus.CacheNotExists;
        } else {
            oldLoadedFromFile = oldValue.isLoadedFromFile();
            oldRevision = oldValue.getRevision();
            CacheHandler.CachedStatus cachedStatus2 = cachedStatus = oldRevision.equals(newRevision) && !oldLoadedFromFile ? CacheHandler.CachedStatus.CacheNotChanged : CacheHandler.CachedStatus.CacheChanged;
        }
        if (cachedStatus != CacheHandler.CachedStatus.CacheNotChanged) {
            LOG.info("resource {} has updated, compare status {}, old revision is {}, old loadedFromFile is {}, new revision is {}", new Object[]{serviceEventKey, cachedStatus, oldRevision, oldLoadedFromFile, newRevision});
        } else {
            LOG.debug("resource {} is not updated, compare status {}, old revision is {}, old loadedFromFile is {}, new revision is {}", new Object[]{serviceEventKey, cachedStatus, oldRevision, oldLoadedFromFile, newRevision});
        }
        return cachedStatus;
    }
}

