/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.tencent.polaris.api.plugin.registry.CacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.plugins.connector.grpc.codec.CommonHandler;
import java.util.function.Function;

public class ServiceInstancesCacheHandler
implements CacheHandler {
    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.INSTANCE;
    }

    public CacheHandler.CachedStatus compareMessage(RegistryCacheValue oldValue, Object newValue) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        return CommonHandler.compareMessage(this.getTargetEventType(), oldValue, discoverResponse, new Function<ResponseProto.DiscoverResponse, String>(){

            @Override
            public String apply(ResponseProto.DiscoverResponse discoverResponse) {
                return discoverResponse.getService().getRevision().getValue();
            }
        });
    }

    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        ServiceInstancesByProto oldServiceInstances = null;
        if (null != oldValue) {
            oldServiceInstances = (ServiceInstancesByProto)oldValue;
        }
        return new ServiceInstancesByProto(discoverResponse, oldServiceInstances, isCacheLoaded);
    }
}

