/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import com.tencent.polaris.plugins.connector.grpc.Connection;
import com.tencent.polaris.plugins.connector.grpc.ConnectionManager;
import com.tencent.polaris.plugins.connector.grpc.GrpcConnector;
import com.tencent.polaris.plugins.connector.grpc.SpecStreamClient;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class GrpcServiceUpdateTask
extends ServiceUpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceUpdateTask.class);
    private final AtomicLong msgSendTime = new AtomicLong(0L);
    private final AtomicLong totalRequests = new AtomicLong(0L);

    public GrpcServiceUpdateTask(ServiceEventHandler handler, DestroyableServerConnector connector) {
        super(handler, connector);
    }

    public void execute() {
        this.execute(this);
    }

    public void execute(ServiceUpdateTask serviceUpdateTask) {
        if (serviceUpdateTask.getTaskType() == ServiceUpdateTaskConstant.Type.FIRST) {
            LOG.info("[ServerConnector]start to run first task {}", (Object)serviceUpdateTask);
        } else {
            LOG.debug("[ServerConnector]start to run task {}", (Object)serviceUpdateTask);
        }
        GrpcConnector grpcConnector = (GrpcConnector)this.serverConnector;
        ConnectionManager connectionManager = grpcConnector.getConnectionManager();
        ClusterType clusterType = (ClusterType)this.targetClusterType.get();
        boolean clusterReady = connectionManager.checkReady(clusterType);
        if (!clusterReady) {
            LOG.info("{} service is not ready", (Object)clusterType);
            grpcConnector.retryServiceUpdateTask(serviceUpdateTask);
            return;
        }
        if (grpcConnector.isDestroyed()) {
            LOG.info("{} grpc connection is destroyed", (Object)clusterType);
            grpcConnector.retryServiceUpdateTask(serviceUpdateTask);
            return;
        }
        AtomicReference<SpecStreamClient> streamClientAtomicReference = grpcConnector.getStreamClient(clusterType);
        SpecStreamClient specStreamClient = streamClientAtomicReference.get();
        boolean available = this.checkStreamClientAvailable(specStreamClient, serviceUpdateTask);
        if (!available) {
            LOG.debug("[ServerConnector]start to get connection for task {}", (Object)serviceUpdateTask);
            Connection connection = null;
            try {
                connection = connectionManager.getConnection("Discover", clusterType);
            }
            catch (PolarisException e) {
                LOG.error("[ServerConnector]fail to get connection to {}", (Object)clusterType, (Object)e);
            }
            if (null == connection) {
                LOG.error("[ServerConnector]get null connection for {}", (Object)serviceUpdateTask);
                grpcConnector.retryServiceUpdateTask(serviceUpdateTask);
                return;
            }
            specStreamClient = new SpecStreamClient(connection, grpcConnector.getConnectionIdleTimeoutMs(), serviceUpdateTask);
            streamClientAtomicReference.set(specStreamClient);
            LOG.info("[ServerConnector]success to create stream client for task {}", (Object)serviceUpdateTask);
        }
        this.msgSendTime.set(System.currentTimeMillis());
        this.totalRequests.addAndGet(1L);
        specStreamClient.sendRequest(serviceUpdateTask);
    }

    protected void handle(Throwable throwable) {
        LOG.error("Grpc service task execute error.", throwable);
    }

    private boolean checkStreamClientAvailable(SpecStreamClient streamClient, ServiceUpdateTask serviceUpdateTask) {
        if (null == streamClient) {
            return false;
        }
        return streamClient.checkAvailable(serviceUpdateTask);
    }

    public String toString() {
        return "GrpcServiceUpdateTask{taskType=" + this.taskType.get() + ", taskStatus=" + this.taskStatus.get() + ", serviceEventKey=" + this.serviceEventKey + ", targetClusterType=" + this.targetClusterType.get() + '}';
    }

    public boolean notifyServerEvent(ServerEvent serverEvent) {
        this.taskStatus.compareAndSet(ServiceUpdateTaskConstant.Status.RUNNING, ServiceUpdateTaskConstant.Status.READY);
        this.lastUpdateTime.set(System.currentTimeMillis());
        if (null == serverEvent.getError()) {
            this.successUpdates.addAndGet(1L);
        }
        return this.getEventHandler().onEventUpdate(serverEvent);
    }
}

