/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.client.pb.RateLimitProto;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.plugins.connector.grpc.codec.AbstractCacheHandler;
import java.util.ArrayList;
import java.util.List;

public class RateLimitingCacheHandler
extends AbstractCacheHandler {
    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.RATE_LIMITING;
    }

    @Override
    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        RateLimitProto.RateLimit rateLimit = discoverResponse.getRateLimit();
        if (null == rateLimit) {
            return "";
        }
        return rateLimit.getRevision().getValue();
    }

    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        RateLimitProto.RateLimit rateLimit = discoverResponse.getRateLimit();
        String revision = this.getRevision(discoverResponse);
        List rulesList = rateLimit.getRulesList();
        ArrayList sortedRules = new ArrayList(rulesList);
        sortedRules.sort((o1, o2) -> {
            if (o1.getPriority().getValue() != o2.getPriority().getValue()) {
                return o1.getPriority().getValue() - o2.getPriority().getValue();
            }
            return o1.getId().getValue().compareTo(o2.getId().getValue());
        });
        RateLimitProto.RateLimit newRateLimit = RateLimitProto.RateLimit.newBuilder().addAllRules(sortedRules).setRevision(StringValue.newBuilder().setValue(revision).build()).build();
        return new ServiceRuleByProto((Message)newRateLimit, revision, isCacheLoaded, this.getTargetEventType());
    }
}

