/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.plugins.connector.grpc.ChannelTlsCertificates;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;

public final class ManagedChannelUtil {
    public static void setChannelTls(ManagedChannelBuilder<?> builder, ChannelTlsCertificates tlsCertificates) throws SSLException {
        Objects.requireNonNull(tlsCertificates, "Channel tls certificates can't be null");
        String channelBuilderClassName = builder.getClass().getName();
        if (channelBuilderClassName.equals("io.grpc.netty.NettyChannelBuilder")) {
            NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)builder;
            nettyBuilder.sslContext(GrpcSslContexts.forClient().keyManager((KeyManager)tlsCertificates.getKeyManager()).trustManager((TrustManager)tlsCertificates.getTrustManager()).build());
        } else if (channelBuilderClassName.equals("io.grpc.okhttp.OkHttpChannelBuilder")) {
            OkHttpChannelBuilder okHttpBuilder = (OkHttpChannelBuilder)builder;
            try {
                KeyManager[] keyManagerArray;
                SSLContext sslContext = SSLContext.getInstance("TLS");
                X509KeyManager keyManager = tlsCertificates.getKeyManager();
                if (keyManager == null) {
                    keyManagerArray = null;
                } else {
                    KeyManager[] keyManagerArray2 = new KeyManager[1];
                    keyManagerArray = keyManagerArray2;
                    keyManagerArray2[0] = keyManager;
                }
                sslContext.init(keyManagerArray, new TrustManager[]{tlsCertificates.getTrustManager()}, null);
                okHttpBuilder.sslSocketFactory(sslContext.getSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new SSLException("Could not set SslContext to okHttpBuilder.", e);
            }
        } else {
            throw new SSLException("Unsupported ManagedChannelBuilder: " + channelBuilderClassName);
        }
    }
}

