/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.http;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.http.Config;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;

public class HttpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHealthChecker.class);
    private static final String DEFAULT_METHOD = "GET";
    private static final String DEFAULT_PATH = "/";
    private int timeoutMs = 0;
    private FaultDetectorProto.HttpProtocolConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetectResult detectInstance(Instance instance, FaultDetectorProto.FaultDetectRule faultDetectRule) throws PolarisException {
        int curTimeout = this.timeoutMs;
        FaultDetectorProto.HttpProtocolConfig curConfig = this.config;
        int curPort = instance.getPort();
        if (null != faultDetectRule && faultDetectRule.getProtocol() == FaultDetectorProto.FaultDetectRule.Protocol.HTTP) {
            if (faultDetectRule.getTimeout() > 0) {
                curTimeout = faultDetectRule.getTimeout();
            }
            if (faultDetectRule.hasHttpConfig()) {
                curConfig = faultDetectRule.getHttpConfig();
            }
            if (faultDetectRule.getPort() > 0) {
                curPort = faultDetectRule.getPort();
            }
        }
        String method = curConfig.getMethod();
        String pathStr = curConfig.getUrl();
        List headersList = curConfig.getHeadersList();
        String body = curConfig.getBody();
        HttpURLConnection conn = null;
        OutputStream outputStream = null;
        String path = String.format("http://%s:%d%s", instance.getHost(), curPort, pathStr);
        try {
            int responseCode;
            FaultDetectorProto.HttpProtocolConfig.MessageHeader messageHeader2;
            URL url = new URL(path);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method);
            if (headersList.size() > 0) {
                for (FaultDetectorProto.HttpProtocolConfig.MessageHeader messageHeader2 : headersList) {
                    conn.addRequestProperty(messageHeader2.getKey(), messageHeader2.getValue());
                }
            }
            conn.setConnectTimeout(curTimeout);
            conn.setReadTimeout(curTimeout);
            if (StringUtils.isNotBlank((String)body)) {
                conn.setDoOutput(true);
                outputStream = conn.getOutputStream();
                byte[] input = body.getBytes(StandardCharsets.UTF_8);
                outputStream.write(input, 0, input.length);
            }
            if ((responseCode = conn.getResponseCode()) >= 500) {
                messageHeader2 = new DetectResult(RetStatus.RetFail);
                return messageHeader2;
            }
            messageHeader2 = new DetectResult(RetStatus.RetSuccess);
            return messageHeader2;
        }
        catch (Exception e) {
            LOG.warn("http detect exception, service:{}, host:{}, port:{}.", new Object[]{instance.getService(), instance.getHost(), instance.getPort()});
            DetectResult detectResult = new DetectResult(RetStatus.RetFail);
            return detectResult;
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException ioException) {
                    LOG.error("fail to close output stream for url {}", (Object)path, (Object)ioException);
                }
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public String getName() {
        return "http";
    }

    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = (Config)outlierDetection.getPluginConfig(this.getName(), Config.class);
        FaultDetectorProto.HttpProtocolConfig.Builder builder = FaultDetectorProto.HttpProtocolConfig.newBuilder();
        if (null == cfg || StringUtils.isBlank((String)cfg.getPath())) {
            builder.setUrl(DEFAULT_PATH);
        }
        this.timeoutMs = null != cfg && null != cfg.getTimeout() && cfg.getTimeout() > 0L ? (int)cfg.getTimeout().longValue() : 1000;
        builder.setMethod(DEFAULT_METHOD);
        this.config = builder.build();
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    public void destroy() {
    }
}

