/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.tcp;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.ConversionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.tcp.Config;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;

public class TcpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TcpHealthChecker.class);
    private FaultDetectorProto.TcpProtocolConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public DetectResult detectInstance(Instance instance, FaultDetectorProto.FaultDetectRule faultDetectRule) throws PolarisException {
        DetectResult detectResult;
        Socket socket;
        int port;
        String host;
        block32: {
            block30: {
                DetectResult detectResult2;
                block31: {
                    HashSet<String> expectRecvStrs;
                    int maxLength;
                    block28: {
                        DetectResult e222;
                        block29: {
                            byte[] sendBytes;
                            int timeoutMs;
                            block26: {
                                Object receiveBytes;
                                block27: {
                                    boolean needSendData;
                                    host = instance.getHost();
                                    port = instance.getPort();
                                    FaultDetectorProto.TcpProtocolConfig curConfig = this.config;
                                    timeoutMs = 1000;
                                    if (null != faultDetectRule && faultDetectRule.getProtocol() == FaultDetectorProto.FaultDetectRule.Protocol.TCP) {
                                        if (faultDetectRule.getTimeout() > 0) {
                                            timeoutMs = faultDetectRule.getTimeout();
                                        }
                                        if (faultDetectRule.getPort() > 0) {
                                            port = faultDetectRule.getPort();
                                        }
                                        curConfig = faultDetectRule.getTcpConfig();
                                    }
                                    sendBytes = null;
                                    maxLength = 0;
                                    expectRecvStrs = new HashSet<String>();
                                    if (null != curConfig) {
                                        if (StringUtils.isNotBlank((String)curConfig.getSend())) {
                                            sendBytes = ConversionUtils.anyStringToByte((String)curConfig.getSend());
                                        }
                                        for (String receiveStr : curConfig.getReceiveList()) {
                                            String hexStr;
                                            receiveBytes = ConversionUtils.anyStringToByte((String)receiveStr);
                                            if (null == receiveBytes || !StringUtils.isNotBlank((String)(hexStr = ConversionUtils.byteArrayToHexString((byte[])receiveBytes)))) continue;
                                            expectRecvStrs.add(hexStr);
                                            if (((byte[])receiveBytes).length <= maxLength) continue;
                                            maxLength = ((byte[])receiveBytes).length;
                                        }
                                    }
                                    socket = null;
                                    socket = new Socket(host, port);
                                    boolean bl = needSendData = null != sendBytes && sendBytes.length > 0;
                                    if (needSendData) break block26;
                                    receiveBytes = new DetectResult(RetStatus.RetSuccess);
                                    if (socket == null) break block27;
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException e222) {
                                        LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e222});
                                    }
                                }
                                return receiveBytes;
                            }
                            socket.setSoTimeout(timeoutMs);
                            OutputStream os = socket.getOutputStream();
                            os.write(sendBytes);
                            os.flush();
                            if (!expectRecvStrs.isEmpty()) break block28;
                            e222 = new DetectResult(RetStatus.RetSuccess);
                            if (socket == null) break block29;
                            try {
                                socket.close();
                            }
                            catch (IOException e3) {
                                LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e3});
                            }
                        }
                        return e222;
                    }
                    byte[] recvBytes = this.recvFromSocket(socket, maxLength);
                    byte[] recvBytesClone = Arrays.copyOfRange(recvBytes, 0, maxLength);
                    String recvHexStr = ConversionUtils.byteArrayToHexString((byte[])recvBytesClone);
                    if (!expectRecvStrs.contains(recvHexStr)) break block30;
                    detectResult2 = new DetectResult(RetStatus.RetSuccess);
                    if (socket == null) break block31;
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e});
                    }
                }
                return detectResult2;
            }
            detectResult = new DetectResult(RetStatus.RetFail);
            if (socket == null) break block32;
            try {
                socket.close();
            }
            catch (IOException e) {
                LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e});
            }
        }
        return detectResult;
        catch (IOException e) {
            DetectResult detectResult3;
            block33: {
                try {
                    LOG.warn("tcp detect instance, create sock exception, host:{}, port:{}.", (Object)host, (Object)port);
                    detectResult3 = new DetectResult(RetStatus.RetFail);
                    if (socket == null) break block33;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e4) {
                            LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e4});
                        }
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException e5) {
                    LOG.info("tcp detect instance, close sock exception, host:{}, port:{}, e:{}", new Object[]{host, port, e5});
                }
            }
            return detectResult3;
        }
    }

    private byte[] recvFromSocket(Socket socket, int maxLen) throws IOException {
        InputStream is = socket.getInputStream();
        byte[] recvBytes = new byte[1024];
        int recvLen = 0;
        while (recvLen + maxLen <= recvBytes.length) {
            int tempLen = is.read(recvBytes, recvLen, maxLen);
            if (tempLen < 0) {
                return recvBytes;
            }
            if ((recvLen += tempLen) >= maxLen) continue;
        }
        return recvBytes;
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public String getName() {
        return "tcp";
    }

    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = (Config)outlierDetection.getPluginConfig(this.getName(), Config.class);
        FaultDetectorProto.TcpProtocolConfig.Builder builder = FaultDetectorProto.TcpProtocolConfig.newBuilder();
        if (null != cfg && StringUtils.isNotBlank((String)cfg.getSend())) {
            builder.setSend(cfg.getSend());
        }
        if (null != cfg && StringUtils.isNotBlank((String)cfg.getReceive())) {
            builder.addReceive(cfg.getReceive());
        }
        this.config = builder.build();
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    public void destroy() {
    }
}

