/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.outlier.detector.udp;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.ConversionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.outlier.detector.udp.Config;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;

public class UdpHealthChecker
implements HealthChecker,
PluginConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(UdpHealthChecker.class);
    private FaultDetectorProto.UdpProtocolConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetectResult detectInstance(Instance instance, FaultDetectorProto.FaultDetectRule faultDetectRule) throws PolarisException {
        boolean needSendData;
        String host = instance.getHost();
        int port = instance.getPort();
        FaultDetectorProto.UdpProtocolConfig curConfig = this.config;
        int timeoutMs = 1000;
        if (null != faultDetectRule && faultDetectRule.getProtocol() == FaultDetectorProto.FaultDetectRule.Protocol.TCP) {
            if (faultDetectRule.getTimeout() > 0) {
                timeoutMs = faultDetectRule.getTimeout();
            }
            if (faultDetectRule.getPort() > 0) {
                port = faultDetectRule.getPort();
            }
            curConfig = faultDetectRule.getUdpConfig();
        }
        byte[] sendBytes = null;
        int maxLength = 0;
        HashSet<String> expectRecvStrs = new HashSet<String>();
        if (null != curConfig) {
            if (StringUtils.isNotBlank((String)curConfig.getSend())) {
                sendBytes = ConversionUtils.anyStringToByte((String)curConfig.getSend());
            }
            for (String receiveStr : curConfig.getReceiveList()) {
                String hexStr;
                byte[] receiveBytes = ConversionUtils.anyStringToByte((String)receiveStr);
                if (null == receiveBytes || !StringUtils.isNotBlank((String)(hexStr = ConversionUtils.byteArrayToHexString((byte[])receiveBytes)))) continue;
                expectRecvStrs.add(hexStr);
                if (receiveBytes.length <= maxLength) continue;
                maxLength = receiveBytes.length;
            }
        }
        boolean bl = needSendData = null != sendBytes && sendBytes.length > 0;
        if (!needSendData) {
            return new DetectResult(RetStatus.RetSuccess);
        }
        try (DatagramSocket socket = null;){
            InetAddress inet = InetAddress.getByName(host);
            socket = new DatagramSocket();
            socket.setSoTimeout(timeoutMs);
            DatagramPacket sendPacket = new DatagramPacket(sendBytes, sendBytes.length, inet, port);
            socket.send(sendPacket);
            byte[] recvBuf = new byte[1024];
            DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
            socket.receive(recvPacket);
            socket.close();
            byte[] recvBytesClone = Arrays.copyOfRange(recvBuf, 0, maxLength);
            String recvHexStr = ConversionUtils.byteArrayToHexString((byte[])recvBytesClone);
            if (expectRecvStrs.contains(recvHexStr)) {
                DetectResult detectResult = new DetectResult(RetStatus.RetSuccess);
                return detectResult;
            }
            DetectResult detectResult = new DetectResult(RetStatus.RetFail);
            return detectResult;
        }
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public String getName() {
        return "udp";
    }

    public PluginType getType() {
        return PluginTypes.HEALTH_CHECKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        Config cfg = (Config)outlierDetection.getPluginConfig(this.getName(), Config.class);
        FaultDetectorProto.UdpProtocolConfig.Builder builder = FaultDetectorProto.UdpProtocolConfig.newBuilder();
        if (null != cfg && StringUtils.isNotBlank((String)cfg.getSend())) {
            builder.setSend(cfg.getSend());
        }
        if (null != cfg && StringUtils.isNotBlank((String)cfg.getReceive())) {
            builder.addReceive(cfg.getReceive());
        }
        this.config = builder.build();
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    public void destroy() {
    }
}

