/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.location.remotehttp;

import com.google.protobuf.StringValue;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.tencent.polaris.api.plugin.location.LocationProvider;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugin.location.base.BaseLocationProvider;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.io.IOException;
import org.slf4j.Logger;

public class RemoteHttpLocationProvider
extends BaseLocationProvider<BaseLocationProvider.GetOption> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHttpLocationProvider.class);
    private final OkHttpClient httpClient = new OkHttpClient();

    public RemoteHttpLocationProvider() {
        super(BaseLocationProvider.GetOption.class);
    }

    public LocationProvider.ProviderType getProviderType() {
        return LocationProvider.ProviderType.REMOTE_HTTP;
    }

    public ModelProto.Location doGet(BaseLocationProvider.GetOption option) {
        String region = this.getResponse(option.getRegion(), "region");
        String zone = this.getResponse(option.getZone(), "zone");
        String campus = this.getResponse(option.getCampus(), "campus");
        if (StringUtils.isAllEmpty((String[])new String[]{region, zone, campus})) {
            return null;
        }
        LOGGER.info("[Location][Provider][RemoteHttp] get location from remote http : {}", (Object)option);
        return ModelProto.Location.newBuilder().setRegion(StringValue.newBuilder().setValue(region).build()).setZone(StringValue.newBuilder().setValue(zone).build()).setCampus(StringValue.newBuilder().setValue(campus).build()).build();
    }

    private String getResponse(String url, String label) {
        if (StringUtils.isEmpty((String)url)) {
            LOGGER.warn("[Location][Provider][RemoteHttp] get {} from remote url is empty", (Object)label);
            return "";
        }
        Request request = new Request.Builder().get().url(url).build();
        Call call = this.httpClient.newCall(request);
        try {
            Response response = call.execute();
            byte[] ret = response.body().bytes();
            if (response.code() != 200) {
                LOGGER.error("[Location][Provider][RemoteHttp] get {} from remote {} fail: {}", new Object[]{label, url, new String(ret)});
                return "";
            }
            return new String(ret);
        }
        catch (IOException e) {
            LOGGER.error("[Location][Provider][RemoteHttp] get {} from remote {} fail : {}", new Object[]{label, url, e.getMessage()});
            return "";
        }
    }
}

