/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.registry;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.listener.ServiceListener;
import com.tencent.polaris.api.pojo.DefaultServiceInstances;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.RouteArgument;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.SourceService;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetServiceRuleRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterResponse;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.rpc.ServiceRuleResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.api.rpc.UnWatchServiceRequest;
import com.tencent.polaris.api.rpc.WatchServiceRequest;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.factory.CircuitBreakAPIFactory;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.common.registry.BootConfigHandler;
import com.tencent.polaris.common.registry.PolarisConfig;
import com.tencent.polaris.common.registry.TimedCache;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import com.tencent.polaris.factory.api.RouterAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.ratelimit.api.core.LimitAPI;
import com.tencent.polaris.ratelimit.api.rpc.Argument;
import com.tencent.polaris.ratelimit.api.rpc.QuotaRequest;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResponse;
import com.tencent.polaris.ratelimit.factory.LimitAPIFactory;
import com.tencent.polaris.router.api.core.RouterAPI;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceRequest;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceResponse;
import com.tencent.polaris.router.api.rpc.ProcessRoutersRequest;
import com.tencent.polaris.router.api.rpc.ProcessRoutersResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.polaris.com.google.protobuf.Message;

public class PolarisOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisOperator.class);
    private final PolarisConfig polarisConfig;
    private SDKContext sdkContext;
    private ConsumerAPI consumerAPI;
    private ProviderAPI providerAPI;
    private LimitAPI limitAPI;
    private RouterAPI routerAPI;
    private CircuitBreakAPI circuitBreakAPI;
    private ConfigFileService configFileService;
    private final Object lock = new Object();
    private final Map<String, TimedCache<Message>> messageCache = new ConcurrentHashMap<String, TimedCache<Message>>();

    public PolarisOperator(String host, int port, Map<String, String> parameters, BootConfigHandler ... handlers) {
        this.polarisConfig = new PolarisConfig(host, port, parameters);
        this.init(parameters, handlers);
    }

    private void init(Map<String, String> parameters, BootConfigHandler ... handlers) {
        ConfigurationImpl configuration = (ConfigurationImpl)ConfigAPIFactory.defaultConfig();
        configuration.setDefault();
        configuration.getGlobal().getServerConnector().setAddresses(Collections.singletonList(this.polarisConfig.getRegistryAddress()));
        configuration.getConfigFile().getServerConnector().setAddresses(Collections.singletonList(this.polarisConfig.getConfigAddress()));
        if (null != handlers && handlers.length > 0) {
            for (BootConfigHandler bootConfigHandler : handlers) {
                bootConfigHandler.handle(parameters, configuration);
            }
        }
        this.sdkContext = SDKContext.initContextByConfig((Configuration)configuration);
        this.consumerAPI = DiscoveryAPIFactory.createConsumerAPIByContext((SDKContext)this.sdkContext);
        this.providerAPI = DiscoveryAPIFactory.createProviderAPIByContext((SDKContext)this.sdkContext);
        this.limitAPI = LimitAPIFactory.createLimitAPIByContext((SDKContext)this.sdkContext);
        this.routerAPI = RouterAPIFactory.createRouterAPIByContext((SDKContext)this.sdkContext);
        this.circuitBreakAPI = CircuitBreakAPIFactory.createCircuitBreakAPIByContext((SDKContext)this.sdkContext);
        this.configFileService = ConfigFileServiceFactory.createConfigFileService((SDKContext)this.sdkContext);
    }

    public void destroy() {
        this.sdkContext.close();
    }

    public void register(String service, String host, int port, String protocol, String version, int weight, Map<String, String> metadata) {
        LOGGER.info("[POLARIS] start to register: service {}, host {}, port {}\uff0c protocol {}, version {}, weight {}, metadata {}", new Object[]{service, host, port, protocol, version, weight, metadata});
        String namespace = this.polarisConfig.getNamespace();
        int ttl = this.polarisConfig.getTtl();
        String token = this.polarisConfig.getToken();
        InstanceRegisterRequest instanceRegisterRequest = new InstanceRegisterRequest();
        instanceRegisterRequest.setNamespace(namespace);
        instanceRegisterRequest.setService(service);
        instanceRegisterRequest.setHost(host);
        instanceRegisterRequest.setPort(Integer.valueOf(port));
        instanceRegisterRequest.setWeight(Integer.valueOf(weight));
        instanceRegisterRequest.setVersion(version);
        instanceRegisterRequest.setTtl(Integer.valueOf(ttl));
        instanceRegisterRequest.setMetadata(metadata);
        instanceRegisterRequest.setProtocol(protocol);
        instanceRegisterRequest.setToken(token);
        InstanceRegisterResponse response = this.providerAPI.registerInstance(instanceRegisterRequest);
        LOGGER.info("register result is {} for service {}", (Object)response, (Object)service);
    }

    public void deregister(String service, String host, int port) {
        LOGGER.info("[POLARIS] start to deregister: service {}, host {}, port {}", new Object[]{service, host, port});
        InstanceDeregisterRequest instanceDeregisterRequest = new InstanceDeregisterRequest();
        instanceDeregisterRequest.setNamespace(this.polarisConfig.getNamespace());
        instanceDeregisterRequest.setService(service);
        instanceDeregisterRequest.setPort(Integer.valueOf(port));
        instanceDeregisterRequest.setHost(host);
        instanceDeregisterRequest.setToken(this.polarisConfig.getToken());
        this.providerAPI.deRegister(instanceDeregisterRequest);
        LOGGER.info("[POLARIS] deregister service {}", (Object)service);
    }

    public boolean watchService(String service, ServiceListener listener) {
        WatchServiceRequest watchServiceRequest = new WatchServiceRequest();
        watchServiceRequest.setNamespace(this.polarisConfig.getNamespace());
        watchServiceRequest.setService(service);
        watchServiceRequest.setListeners(Collections.singletonList(listener));
        return this.consumerAPI.watchService(watchServiceRequest).isSuccess();
    }

    public void unwatchService(String service, ServiceListener serviceListener) {
        UnWatchServiceRequest watchServiceRequest = UnWatchServiceRequest.UnWatchServiceRequestBuilder.anUnWatchServiceRequest().namespace(this.polarisConfig.getNamespace()).service(service).listeners(Collections.singletonList(serviceListener)).build();
        this.consumerAPI.unWatchService(watchServiceRequest);
    }

    public Instance[] getAvailableInstances(String service, boolean includeCircuitBreakInstances) {
        GetHealthyInstancesRequest request = new GetHealthyInstancesRequest();
        request.setNamespace(this.polarisConfig.getNamespace());
        request.setService(service);
        request.setIncludeCircuitBreakInstances(Boolean.valueOf(includeCircuitBreakInstances));
        InstancesResponse instances = this.consumerAPI.getHealthyInstances(request);
        return instances.getInstances();
    }

    public void reportInvokeResult(String service, String method, String host, int port, String callerIp, long delay, RetStatus retStatus, int code) {
        ServiceCallResult serviceCallResult = new ServiceCallResult();
        serviceCallResult.setNamespace(this.polarisConfig.getNamespace());
        serviceCallResult.setService(service);
        serviceCallResult.setMethod(method);
        serviceCallResult.setHost(host);
        serviceCallResult.setPort(port);
        serviceCallResult.setDelay(delay);
        serviceCallResult.setRetStatus(retStatus);
        serviceCallResult.setRetCode(code);
        serviceCallResult.setCallerIp(callerIp);
        this.consumerAPI.updateServiceCallResult(serviceCallResult);
    }

    public List<Instance> route(String service, String method, Set<RouteArgument> arguments, List<Instance> instances) {
        ServiceKey serviceKey = new ServiceKey(this.polarisConfig.getNamespace(), service);
        DefaultServiceInstances defaultServiceInstances = new DefaultServiceInstances(serviceKey, instances);
        SourceService serviceInfo = new SourceService();
        serviceInfo.setArguments(arguments);
        ProcessRoutersRequest request = new ProcessRoutersRequest();
        request.setDstInstances((ServiceInstances)defaultServiceInstances);
        request.setMethod(method);
        request.setSourceService((ServiceInfo)serviceInfo);
        ProcessRoutersResponse processRoutersResponse = this.routerAPI.processRouters(request);
        return processRoutersResponse.getServiceInstances().getInstances();
    }

    public Instance loadBalance(String service, String hashKey, List<Instance> instances) {
        ServiceKey serviceKey = new ServiceKey(this.polarisConfig.getNamespace(), service);
        DefaultServiceInstances defaultServiceInstances = new DefaultServiceInstances(serviceKey, instances);
        ProcessLoadBalanceRequest processLoadBalanceRequest = new ProcessLoadBalanceRequest();
        processLoadBalanceRequest.setDstInstances((ServiceInstances)defaultServiceInstances);
        Criteria criteria = new Criteria();
        criteria.setHashKey(hashKey);
        processLoadBalanceRequest.setCriteria(criteria);
        ProcessLoadBalanceResponse processLoadBalanceResponse = this.routerAPI.processLoadBalance(processLoadBalanceRequest);
        return processLoadBalanceResponse.getTargetInstance();
    }

    public QuotaResponse getQuota(String service, String method, Set<Argument> arguments) {
        QuotaRequest quotaRequest = new QuotaRequest();
        quotaRequest.setNamespace(this.polarisConfig.getNamespace());
        quotaRequest.setService(service);
        quotaRequest.setMethod(method);
        quotaRequest.setArguments(arguments);
        quotaRequest.setCount(1);
        return this.limitAPI.getQuota(quotaRequest);
    }

    public ServiceRule getServiceRule(String service, ServiceEventKey.EventType eventType) {
        GetServiceRuleRequest getServiceRuleRequest = new GetServiceRuleRequest();
        getServiceRuleRequest.setNamespace(this.polarisConfig.getNamespace());
        getServiceRuleRequest.setService(service);
        getServiceRuleRequest.setRuleType(eventType);
        ServiceRuleResponse serviceRule = this.consumerAPI.getServiceRule(getServiceRuleRequest);
        return serviceRule.getServiceRule();
    }

    public List<ServiceInfo> getServices() {
        GetServicesRequest getServicesRequest = new GetServicesRequest();
        getServicesRequest.setNamespace(this.polarisConfig.getNamespace());
        ServicesResponse services = this.consumerAPI.getServices(getServicesRequest);
        return services.getServices();
    }

    public PolarisConfig getPolarisConfig() {
        return this.polarisConfig;
    }

    public ConsumerAPI getConsumerAPI() {
        return this.consumerAPI;
    }

    public ProviderAPI getProviderAPI() {
        return this.providerAPI;
    }

    public LimitAPI getLimitAPI() {
        return this.limitAPI;
    }

    public RouterAPI getRouterAPI() {
        return this.routerAPI;
    }

    public CircuitBreakAPI getCircuitBreakAPI() {
        return this.circuitBreakAPI;
    }
}

