/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.registry;

import com.tencent.polaris.common.registry.PolarisOperator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PolarisOperators {
    private final Map<String, PolarisOperator> polarisOperatorMap = new ConcurrentHashMap<String, PolarisOperator>();
    public static final PolarisOperators INSTANCE = new PolarisOperators();

    private PolarisOperators() {
    }

    public void addPolarisOperator(PolarisOperator polarisOperator) {
        this.polarisOperatorMap.put(polarisOperator.getPolarisConfig().getRegistryAddress(), polarisOperator);
    }

    public PolarisOperator getPolarisOperator(String host, int port) {
        String address = String.format("%s:%d", host, port);
        return this.polarisOperatorMap.get(address);
    }

    public PolarisOperator getFirstPolarisOperator() {
        if (this.polarisOperatorMap.isEmpty()) {
            return null;
        }
        return this.polarisOperatorMap.values().iterator().next();
    }

    public void deletePolarisOperator(String host, int port) {
        String address = String.format("%s:%d", host, port);
        this.polarisOperatorMap.remove(address);
    }
}

