/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.router;

import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.common.registry.TimedCache;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import com.tencent.polaris.specification.api.v1.traffic.manage.RoutingProto;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RuleHandler {
    private final Map<String, TimedCache<Set<String>>> routeRuleMatchLabels = new ConcurrentHashMap<String, TimedCache<Set<String>>>();
    private final Map<String, TimedCache<Set<RateLimitProto.MatchArgument>>> ratelimitArguments = new ConcurrentHashMap<String, TimedCache<Set<RateLimitProto.MatchArgument>>>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRouteLabels(RoutingProto.Routing routing) {
        TimedCache<Set<String>> setTimedCache = this.routeRuleMatchLabels.get(routing.getRevision().getValue());
        if (null != setTimedCache && !setTimedCache.isExpired()) {
            return setTimedCache.getValue();
        }
        Object object = this.lock;
        synchronized (object) {
            setTimedCache = this.routeRuleMatchLabels.get(routing.getRevision().getValue());
            if (null != setTimedCache && !setTimedCache.isExpired()) {
                return setTimedCache.getValue();
            }
            TimedCache<Set<String>> timedCache = new TimedCache<Set<String>>(RuleHandler.buildRouteLabels(routing));
            this.routeRuleMatchLabels.put(routing.getRevision().getValue(), timedCache);
            return timedCache.getValue();
        }
    }

    private static Set<String> buildRouteLabels(RoutingProto.Routing routing) {
        HashSet<String> labels = new HashSet<String>();
        List inboundsList = routing.getInboundsList();
        List outboundsList = routing.getOutboundsList();
        RuleHandler.routeRulesToLabels(inboundsList, labels);
        RuleHandler.routeRulesToLabels(outboundsList, labels);
        return labels;
    }

    private static void routeRulesToLabels(List<RoutingProto.Route> routes, Collection<String> labels) {
        if (CollectionUtils.isEmpty(routes)) {
            return;
        }
        for (RoutingProto.Route route : routes) {
            List sourcesList = route.getSourcesList();
            if (CollectionUtils.isEmpty((Collection)sourcesList)) continue;
            for (RoutingProto.Source source : sourcesList) {
                Map metadataMap = source.getMetadataMap();
                labels.addAll(metadataMap.keySet());
            }
        }
    }

    private static Set<RateLimitProto.MatchArgument> buildRatelimitLabels(RateLimitProto.RateLimit rateLimit) {
        List rulesList = rateLimit.getRulesList();
        HashSet<RateLimitProto.MatchArgument> arguments = new HashSet<RateLimitProto.MatchArgument>();
        for (RateLimitProto.Rule rule : rulesList) {
            List argumentsList = rule.getArgumentsList();
            for (RateLimitProto.MatchArgument matchArgument : argumentsList) {
                arguments.add(RateLimitProto.MatchArgument.newBuilder().setType(matchArgument.getType()).setKey(matchArgument.getKey()).build());
            }
        }
        return arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RateLimitProto.MatchArgument> getRatelimitLabels(RateLimitProto.RateLimit rateLimit) {
        TimedCache<Set<RateLimitProto.MatchArgument>> setTimedCache = this.ratelimitArguments.get(rateLimit.getRevision().getValue());
        if (null != setTimedCache && !setTimedCache.isExpired()) {
            return setTimedCache.getValue();
        }
        Object object = this.lock;
        synchronized (object) {
            setTimedCache = this.ratelimitArguments.get(rateLimit.getRevision().getValue());
            if (null != setTimedCache && !setTimedCache.isExpired()) {
                return setTimedCache.getValue();
            }
            TimedCache<Set<RateLimitProto.MatchArgument>> timedCache = new TimedCache<Set<RateLimitProto.MatchArgument>>(RuleHandler.buildRatelimitLabels(rateLimit));
            this.ratelimitArguments.put(rateLimit.getRevision().getValue(), timedCache);
            return timedCache.getValue();
        }
    }
}

