/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.rls;

import java.util.Map;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.io.grpc.Internal;
import shade.polaris.io.grpc.LoadBalancer;
import shade.polaris.io.grpc.LoadBalancerProvider;
import shade.polaris.io.grpc.NameResolver;
import shade.polaris.io.grpc.Status;
import shade.polaris.io.grpc.internal.JsonUtil;
import shade.polaris.io.grpc.rls.LbPolicyConfiguration;
import shade.polaris.io.grpc.rls.RlsLoadBalancer;
import shade.polaris.io.grpc.rls.RlsProtoConverters;
import shade.polaris.io.grpc.rls.RlsProtoData;

@Internal
public final class RlsLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public String getPolicyName() {
        return "rls_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RlsLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            RlsProtoData.RouteLookupConfig routeLookupConfig = (RlsProtoData.RouteLookupConfig)new RlsProtoConverters.RouteLookupConfigConverter().convert(JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupConfig"));
            Map<String, ?> routeLookupChannelServiceConfig = JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupChannelServiceConfig");
            LbPolicyConfiguration.ChildLoadBalancingPolicy lbPolicy = LbPolicyConfiguration.ChildLoadBalancingPolicy.create(JsonUtil.getString(rawLoadBalancingConfigPolicy, "childPolicyConfigTargetFieldName"), JsonUtil.checkObjectList(Preconditions.checkNotNull(JsonUtil.getList(rawLoadBalancingConfigPolicy, "childPolicy"))));
            return NameResolver.ConfigOrError.fromConfig(new LbPolicyConfiguration(routeLookupConfig, routeLookupChannelServiceConfig, lbPolicy));
        }
        catch (Exception e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("can't parse config: " + e.getMessage()).withCause(e));
        }
    }
}

