/*
 * Tencent is pleased to support the open source community by making Polaris available.
 *
 * Copyright (C) 2019 THL A29 Limited, a Tencent company. All rights reserved.
 *
 * Licensed under the BSD 3-Clause License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://opensource.org/licenses/BSD-3-Clause
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.tencent.polaris.api.config.consumer;

import com.tencent.polaris.api.config.plugin.PluginConfig;
import com.tencent.polaris.api.config.verify.Verifier;
import java.util.List;

/**
 * OutlierDetectionConfig.java
 *
 * @author andrewshan
 * @date 2019/9/18
 */
public interface OutlierDetectionConfig extends PluginConfig, Verifier {

    enum When {
        never, on_recover, always
    }

    /**
     * 何时启用探测
     *
     * @return when
     */
    When getWhen();

    /**
     * 探测器插件链
     *
     * @return 探测插件列表
     */
    List<String> getChain();

    /**
     * 探测器定时检测时间
     *
     * @return long, 毫秒
     */
    long getCheckPeriod();

}