/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.global.ClusterConfig;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.config.global.SystemConfig;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Manager;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.Supplier;
import com.tencent.polaris.api.plugin.TypeProvider;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.ServerServiceInfo;
import com.tencent.polaris.api.plugin.impl.PluginManager;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.plugin.stat.ReporterMetaInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.AbstractFlow;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.logging.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import shade.polaris.com.fasterxml.jackson.core.JsonProcessingException;
import shade.polaris.com.fasterxml.jackson.databind.json.JsonMapper;

public class SDKContext
extends Destroyable
implements InitContext,
AutoCloseable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SDKContext.class);
    private static final String DEFAULT_ADDRESS = "127.0.0.1";
    private final Configuration configuration;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Manager plugins;
    private final ValueContext valueContext;
    private final Extensions extensions = new Extensions();
    private final Object lock = new Object();
    private final List<Destroyable> destroyHooks = new ArrayList<Destroyable>();
    private final Collection<ServerServiceInfo> serverServices;
    private final ScheduledExecutorService reportClientExecutorService;

    public SDKContext(Configuration configuration, Manager plugins, ValueContext valueContext) {
        ClusterConfig monitorCluster;
        ClusterConfig healthCheckCluster;
        ClusterConfig configCluster;
        this.configuration = configuration;
        this.plugins = plugins;
        this.valueContext = valueContext;
        this.valueContext.setClientId(SDKContext.generateClientId(this.valueContext.getHost()));
        ArrayList<ServerServiceInfo> services = new ArrayList<ServerServiceInfo>();
        SystemConfig system = configuration.getGlobal().getSystem();
        ClusterConfig discoverCluster = system.getDiscoverCluster();
        if (this.clusterAvailable(discoverCluster)) {
            services.add(new ServerServiceInfo(ClusterType.SERVICE_DISCOVER_CLUSTER, discoverCluster));
        }
        if (this.clusterAvailable(configCluster = system.getConfigCluster())) {
            services.add(new ServerServiceInfo(ClusterType.SERVICE_CONFIG_CLUSTER, configCluster));
        }
        if (this.clusterAvailable(healthCheckCluster = system.getHealthCheckCluster())) {
            services.add(new ServerServiceInfo(ClusterType.HEALTH_CHECK_CLUSTER, healthCheckCluster));
        }
        if (this.clusterAvailable(monitorCluster = system.getMonitorCluster())) {
            services.add(new ServerServiceInfo(ClusterType.MONITOR_CLUSTER, monitorCluster));
        }
        this.serverServices = Collections.unmodifiableCollection(services);
        this.reportClientExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("polaris-report-client"));
    }

    private static String generateClientId(String host) {
        return host + "-" + SDKContext.getProcessId("0");
    }

    private static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static SDKContext initContext() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return SDKContext.initContextByConfig(configuration);
    }

    public static SDKContext initContextByConfig(Configuration config) throws PolarisException {
        try {
            ((ConfigurationImpl)config).setDefault();
            config.verify();
            JsonMapper mapper = new JsonMapper();
            LOG.info("SDKContext config {} ", (Object)mapper.writeValueAsString(config));
        }
        catch (IllegalArgumentException e) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, "fail to verify configuration", e);
        }
        catch (JsonProcessingException e) {
            // empty catch block
        }
        ServiceLoader<TypeProvider> providers = ServiceLoader.load(TypeProvider.class);
        ArrayList<PluginType> types = new ArrayList<PluginType>();
        for (TypeProvider provider : providers) {
            types.addAll(provider.getTypes());
        }
        PluginManager manager = new PluginManager(types);
        ValueContext valueContext = new ValueContext();
        valueContext.setHost(SDKContext.parseHost(config));
        valueContext.setServerConnectorProtocol(SDKContext.parseServerConnectorProtocol(config));
        SDKContext initContext = new SDKContext(config, manager, valueContext);
        try {
            manager.initPlugins(initContext);
        }
        catch (Throwable e) {
            manager.destroyPlugins();
            if (e instanceof PolarisException) {
                throw e;
            }
            throw new PolarisException(ErrorCode.PLUGIN_ERROR, "plugin error", e);
        }
        return initContext;
    }

    public static String parseHost(Configuration configuration) {
        String hostAddress = configuration.getGlobal().getAPI().getBindIP();
        if (!StringUtils.isBlank(hostAddress)) {
            return hostAddress;
        }
        String nic = configuration.getGlobal().getAPI().getBindIf();
        if (StringUtils.isNotBlank(nic)) {
            return SDKContext.resolveAddress(nic);
        }
        try {
            return SDKContext.getHostByDial(configuration);
        }
        catch (IOException e) {
            LOG.error("[ReportClient]get address by dial failed", (Throwable)e);
            return DEFAULT_ADDRESS;
        }
    }

    public static String parseServerConnectorProtocol(Configuration configuration) {
        String protocol = CollectionUtils.isNotEmpty(configuration.getGlobal().getServerConnectors()) ? "composite" : configuration.getGlobal().getServerConnector().getProtocol();
        return protocol;
    }

    private static String getHostByDial(Configuration configuration) throws IOException {
        String serverAddress = CollectionUtils.isNotEmpty(configuration.getGlobal().getServerConnectors()) ? configuration.getGlobal().getServerConnectors().get(0).getAddresses().get(0) : configuration.getGlobal().getServerConnector().getAddresses().get(0);
        String[] tokens = serverAddress.split(":");
        try (Socket socket = new Socket(tokens[0], Integer.parseInt(tokens[1]));){
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
    }

    private static NetworkInterface resolveNetworkInterface(String nic) {
        NetworkInterface ni = null;
        try {
            ni = NetworkInterface.getByName(nic);
        }
        catch (SocketException e) {
            LOG.error("[ReportClient]get nic failed, nic:{}", (Object)nic, (Object)e);
        }
        if (null != ni) {
            return ni;
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.getInetAddresses().hasMoreElements()) continue;
                return networkInterface;
            }
        }
        catch (SocketException e) {
            LOG.error("[ReportClient]get all network interfaces failed", (Throwable)e);
        }
        return null;
    }

    private static String resolveAddress(String nic) {
        NetworkInterface ni = SDKContext.resolveNetworkInterface(nic);
        if (null == ni) {
            return DEFAULT_ADDRESS;
        }
        Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
        if (inetAddresses.hasMoreElements()) {
            InetAddress inetAddress = inetAddresses.nextElement();
            return inetAddress.getCanonicalHostName();
        }
        return DEFAULT_ADDRESS;
    }

    public synchronized void init() throws PolarisException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        this.extensions.init(this.configuration, this.plugins, this.valueContext);
        this.plugins.postContextInitPlugins(this.extensions);
        this.reportClient(this.extensions);
    }

    private boolean clusterAvailable(ClusterConfig clusterConfig) {
        if (null == clusterConfig) {
            return false;
        }
        if (StringUtils.isBlank(clusterConfig.getNamespace()) || StringUtils.isBlank(clusterConfig.getService())) {
            return false;
        }
        return !clusterConfig.isSameAsBuiltin();
    }

    private void reportClient(Extensions extensions) {
        this.reportClientExecutorService.scheduleAtFixedRate(() -> {
            ServerConnector serverConnector = extensions.getServerConnector();
            ReportClientRequest reportClientRequest = new ReportClientRequest();
            reportClientRequest.setClientHost(extensions.getValueContext().getHost());
            reportClientRequest.setVersion("1.14.1");
            List<StatReporter> statPlugins = extensions.getStatReporters();
            ArrayList<ReporterMetaInfo> reporterMetaInfos = new ArrayList<ReporterMetaInfo>();
            for (StatReporter statPlugin : statPlugins) {
                ReporterMetaInfo reporterMetaInfo = statPlugin.metaInfo();
                if (!StringUtils.isNotBlank(reporterMetaInfo.getProtocol())) continue;
                reporterMetaInfos.add(reporterMetaInfo);
            }
            reportClientRequest.setReporterMetaInfos(reporterMetaInfos);
            try {
                ReportClientResponse reportClientResponse = serverConnector.reportClient(reportClientRequest);
                LOG.debug("Report client success, response:{}", (Object)reportClientResponse);
            }
            catch (PolarisException e) {
                LOG.error("Report client failed.", (Throwable)e);
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public Configuration getConfig() {
        return this.configuration;
    }

    @Override
    public Supplier getPlugins() {
        return this.plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDestroy() {
        Object object = this.lock;
        synchronized (object) {
            for (Destroyable destroyable : this.destroyHooks) {
                destroyable.destroy();
            }
        }
        this.plugins.destroyPlugins();
        if (Objects.nonNull(this.reportClientExecutorService)) {
            this.reportClientExecutorService.shutdown();
        }
    }

    @Override
    public ValueContext getValueContext() {
        return this.valueContext;
    }

    @Override
    public Collection<ServerServiceInfo> getServerServices() {
        return this.serverServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestroyHook(Destroyable destroyable) {
        Object object = this.lock;
        synchronized (object) {
            this.destroyHooks.add(destroyable);
        }
    }

    @Override
    public void close() {
        this.destroy();
    }

    private static <T extends AbstractFlow> T loadFlow(String name, Class<T> clazz) {
        ServiceLoader<AbstractFlow> flows = ServiceLoader.load(clazz);
        for (AbstractFlow flow : flows) {
            if (!StringUtils.equals(flow.getName(), name)) continue;
            return (T)flow;
        }
        throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("unknown flow name %s, type is %s", name, clazz.getCanonicalName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractFlow> T getOrInitFlow(Class<T> clazz) {
        Class<T> clazz2 = clazz;
        synchronized (clazz2) {
            Object flowObject = this.valueContext.getValue(clazz.getCanonicalName());
            if (null != flowObject) {
                return (T)((AbstractFlow)flowObject);
            }
            String flowName = this.configuration.getGlobal().getSystem().getFlow().getName();
            T flow = SDKContext.loadFlow(flowName, clazz);
            flow.setSDKContext(this);
            this.valueContext.setValue(clazz.getCanonicalName(), flow);
            return flow;
        }
    }
}

