/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.api.config.configuration.ConfigFileConfig;
import com.tencent.polaris.configuration.api.core.ChangeType;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.api.core.ConfigKVFileChangeEvent;
import com.tencent.polaris.configuration.api.core.ConfigKVFileChangeListener;
import com.tencent.polaris.configuration.api.core.ConfigPropertyChangeInfo;
import com.tencent.polaris.configuration.client.internal.ConfigFileRepo;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFile;
import com.tencent.polaris.configuration.client.util.ConvertFunctions;
import com.tencent.polaris.logging.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import shade.polaris.com.google.common.base.Function;
import shade.polaris.com.google.common.cache.Cache;
import shade.polaris.com.google.common.cache.CacheBuilder;
import shade.polaris.com.google.common.collect.Lists;
import shade.polaris.com.google.common.collect.Maps;

public class ConfigPropertiesFile
extends DefaultConfigFile
implements ConfigKVFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPropertiesFile.class);
    private final List<ConfigKVFileChangeListener> listeners = Lists.newCopyOnWriteArrayList();
    private AtomicReference<Properties> properties;
    private volatile Cache<String, Integer> integerCache;
    private volatile Cache<String, Long> longCache;
    private volatile Cache<String, Short> shortCache;
    private volatile Cache<String, Float> floatCache;
    private volatile Cache<String, Double> doubleCache;
    private volatile Cache<String, Byte> byteCache;
    private volatile Cache<String, Boolean> booleanCache;
    private final Map<String, Cache<String, String[]>> arrayCache = Maps.newConcurrentMap();
    private final List<Cache> allCaches = Lists.newArrayList();
    private final AtomicLong cacheVersion = new AtomicLong();

    public ConfigPropertiesFile(String namespace, String fileGroup, String fileName, ConfigFileRepo configFileRepo, ConfigFileConfig configFileConfig) {
        super(namespace, fileGroup, fileName, configFileRepo, configFileConfig);
    }

    @Override
    protected void initialize() {
        this.properties = new AtomicReference();
        super.initialize();
        Properties properties = this.convertToProperties(this.getContent());
        this.properties.set(properties);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get().getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getIntProperty(String key, Integer defaultValue) {
        try {
            if (this.integerCache == null) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (this.integerCache == null) {
                        this.integerCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, ConvertFunctions.TO_INT_FUNCTION, this.integerCache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to int error. return default value.", ex);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLongProperty(String key, Long defaultValue) {
        try {
            if (this.longCache == null) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (this.longCache == null) {
                        this.longCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, ConvertFunctions.TO_LONG_FUNCTION, this.longCache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to long error. return default value.", ex);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short getShortProperty(String key, Short defaultValue) {
        try {
            if (this.shortCache == null) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (this.shortCache == null) {
                        this.shortCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, ConvertFunctions.TO_SHORT_FUNCTION, this.shortCache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to short error. return default value.", ex);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getFloatProperty(String key, Float defaultValue) {
        try {
            if (this.floatCache == null) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (this.floatCache == null) {
                        this.floatCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, ConvertFunctions.TO_FLOAT_FUNCTION, this.floatCache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to float error. return default value.", ex);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getDoubleProperty(String key, Double defaultValue) {
        try {
            if (this.doubleCache == null) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (this.doubleCache == null) {
                        this.doubleCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, ConvertFunctions.TO_DOUBLE_FUNCTION, this.doubleCache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to double error. return default value.", ex);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte getByteProperty(String key, Byte defaultValue) {
        try {
            if (this.byteCache == null) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (this.byteCache == null) {
                        this.byteCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, ConvertFunctions.TO_BYTE_FUNCTION, this.byteCache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to byte error. return default value.", ex);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        try {
            if (this.booleanCache == null) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (this.booleanCache == null) {
                        this.booleanCache = this.newCache();
                    }
                }
            }
            return this.getValueFromCache(key, ConvertFunctions.TO_BOOLEAN_FUNCTION, this.booleanCache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to boolean error. return default value.", ex);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getArrayProperty(String key, final String delimiter, String[] defaultValue) {
        try {
            Cache<String, String[]> cache;
            String[] result;
            if (!this.arrayCache.containsKey(delimiter)) {
                ConfigPropertiesFile configPropertiesFile = this;
                synchronized (configPropertiesFile) {
                    if (!this.arrayCache.containsKey(delimiter)) {
                        this.arrayCache.put(delimiter, this.newCache());
                    }
                }
            }
            if ((result = (cache = this.arrayCache.get(delimiter)).getIfPresent(key)) != null) {
                return result;
            }
            return this.getValueAndStoreToCache(key, new Function<String, String[]>(){

                @Override
                public String[] apply(String input) {
                    return input.split(delimiter);
                }
            }, cache, defaultValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to array error. return default value.", ex);
            return defaultValue;
        }
    }

    @Override
    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumType, T defaultValue) {
        try {
            String value = this.getProperty(key, null);
            if (value != null) {
                return Enum.valueOf(enumType, value);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("[Config] convert to enum error. return default value.", ex);
        }
        return defaultValue;
    }

    @Override
    public <T> T getJsonProperty(String key, Class<T> clazz, T defaultValue) {
        try {
            String json = this.getProperty(key, null);
            if (json != null) {
                return this.convertToJson(key, json, null, clazz, defaultValue);
            }
        }
        catch (Throwable t) {
            LOGGER.error("[Config] convert to json object error. return default value. clazz = {}", (Object)clazz.getTypeName(), (Object)t);
        }
        return defaultValue;
    }

    @Override
    public <T> T getJsonProperty(String key, Type typeOfT, T defaultValue) {
        try {
            String json = this.getProperty(key, null);
            if (json != null) {
                return this.convertToJson(key, json, typeOfT, null, defaultValue);
            }
        }
        catch (Throwable t) {
            LOGGER.error("[Config] convert to json object error. return default value. clazz = {}", (Object)typeOfT, (Object)t);
        }
        return defaultValue;
    }

    @Override
    public <T> T asJson(Type typeOfT, T defaultValue) {
        throw new IllegalStateException("Properties or yaml file can not convert to json");
    }

    @Override
    public <T> T asJson(Class<T> objectType, T defaultValue) {
        throw new IllegalStateException("Properties or yaml file can not convert to json");
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.stringPropertyNames(this.properties.get());
    }

    @Override
    public void addChangeListener(ConfigKVFileChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeChangeListener(ConfigKVFileChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onChange(ConfigFileMetadata configFileMetadata, String newContent) {
        String key;
        super.onChange(configFileMetadata, newContent);
        Properties oldProperties = this.properties.get();
        if (oldProperties == null) {
            oldProperties = new Properties();
        }
        Properties newProperties = this.convertToProperties(newContent);
        this.properties.set(newProperties);
        HashMap<String, ConfigPropertyChangeInfo> changeInfos = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            key = entry.getKey().toString();
            String newValue = entry.getValue().toString();
            String oldValue = oldProperties.getProperty(key);
            if (oldValue == null) {
                changeInfos.put(key, new ConfigPropertyChangeInfo(key, null, newValue, ChangeType.ADDED));
                continue;
            }
            if (Objects.equals(oldValue, newValue)) continue;
            changeInfos.put(key, new ConfigPropertyChangeInfo(key, oldValue, newValue, ChangeType.MODIFIED));
        }
        for (Map.Entry<Object, Object> entry : oldProperties.entrySet()) {
            key = entry.getKey().toString();
            Object oldValue = entry.getValue();
            if (newProperties.containsKey(key)) continue;
            changeInfos.put(key, new ConfigPropertyChangeInfo(key, oldValue, null, ChangeType.DELETED));
        }
        this.clearConfigCache();
        ConfigKVFileChangeEvent event = new ConfigKVFileChangeEvent(changeInfos);
        this.fireChangeEvent(event);
    }

    protected Properties convertToProperties(String content) {
        Properties properties = new Properties();
        if (content == null) {
            return properties;
        }
        this.convertToProperties(properties, content);
        return properties;
    }

    protected void convertToProperties(Properties properties, String content) {
        try {
            properties.load(new InputStreamReader(new ByteArrayInputStream(content.getBytes())));
        }
        catch (IOException e) {
            String msg = String.format("[Config] failed to convert content to properties. namespace = %s, file group = %s, file name = %s", this.getNamespace(), this.getFileGroup(), this.getFileName());
            LOGGER.error(msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    private void fireChangeEvent(ConfigKVFileChangeEvent event) {
        for (ConfigKVFileChangeListener listener : this.listeners) {
            notifyExecutorService.submit(() -> {
                try {
                    long startTime = System.currentTimeMillis();
                    listener.onChange(event);
                    LOGGER.info("[Config] invoke config file change listener success. listener = {}, duration = {} ms", (Object)listener.getClass().getName(), (Object)(System.currentTimeMillis() - startTime));
                }
                catch (Throwable t) {
                    LOGGER.error("[Config] ailed to invoke config file change listener. listener = {}, event = {}", new Object[]{listener.getClass().getName(), event, t});
                }
            });
        }
    }

    private <T> T getValueFromCache(String key, Function<String, T> parser, Cache<String, T> cache, T defaultValue) {
        T result = cache.getIfPresent(key);
        if (result != null) {
            return result;
        }
        return this.getValueAndStoreToCache(key, parser, cache, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getValueAndStoreToCache(String key, Function<String, T> parser, Cache<String, T> cache, T defaultValue) {
        T result;
        long currentCacheVersion = this.cacheVersion.get();
        String value = this.getProperty(key, null);
        if (value != null && (result = parser.apply(value)) != null) {
            ConfigPropertiesFile configPropertiesFile = this;
            synchronized (configPropertiesFile) {
                if (this.cacheVersion.get() == currentCacheVersion) {
                    cache.put(key, result);
                }
            }
            return result;
        }
        return defaultValue;
    }

    private <T> Cache<String, T> newCache() {
        Cache cache = CacheBuilder.newBuilder().maximumSize(this.configFileConfig.getPropertiesValueCacheSize()).expireAfterAccess(this.configFileConfig.getPropertiesValueExpireTime(), TimeUnit.MINUTES).build();
        this.allCaches.add(cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearConfigCache() {
        ConfigPropertiesFile configPropertiesFile = this;
        synchronized (configPropertiesFile) {
            for (Cache c : this.allCaches) {
                if (c == null) continue;
                c.invalidateAll();
            }
            this.cacheVersion.incrementAndGet();
        }
    }

    private Set<String> stringPropertyNames(Properties properties) {
        if (properties == null) {
            return Collections.emptySet();
        }
        LinkedHashMap<String, Object> map = Maps.newLinkedHashMapWithExpectedSize(properties.size());
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (!(k instanceof String)) continue;
            map.put((String)k, v);
        }
        return map.keySet();
    }
}

