/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.internal;

import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroup;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupMetadata;
import com.tencent.polaris.api.plugin.configuration.ConfigFileGroupResponse;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import com.tencent.polaris.configuration.client.internal.RetryableConfigFileGroupConnector;
import com.tencent.polaris.configuration.client.internal.RevisableConfigFileGroup;
import com.tencent.polaris.configuration.client.internal.RevisableConfigFileGroupPullService;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class DefaultRevisableConfigFileGroupPullService
implements RevisableConfigFileGroupPullService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRevisableConfigFileGroupPullService.class);
    private final AtomicReference<Boolean> started = new AtomicReference<Boolean>(false);
    private final Map<com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata, RevisableConfigFileGroup> configFileGroupCache;
    private final ExecutorService pullExecutorPool;
    private final ExecutorService taskStarter;
    private final RetryableConfigFileGroupConnector rpcConnector;

    public DefaultRevisableConfigFileGroupPullService(SDKContext sdkContext, Map<com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata, RevisableConfigFileGroup> configFileGroupCache, ConfigFileGroupConnector connector) {
        this.configFileGroupCache = configFileGroupCache;
        this.rpcConnector = new RetryableConfigFileGroupConnector(connector, this.getPullFailedRetryStrategy());
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.getClass().getSimpleName());
        int threadNum = sdkContext.getConfig().getConfigFile().getServerConnector().getConfigFileGroupThreadNum();
        this.pullExecutorPool = Executors.newFixedThreadPool(threadNum, threadFactory);
        this.taskStarter = Executors.newSingleThreadExecutor(threadFactory);
    }

    public RetryableConfigFileGroupConnector.RetryableValidator getPullFailedRetryStrategy() {
        return response -> {
            switch (response.getCode()) {
                case 200000: 
                case 200001: 
                case 400202: {
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public void pullConfigFileGroup(RevisableConfigFileGroup fileGroup) {
        if (!this.started.get().booleanValue()) {
            this.startPullingTask();
        }
    }

    private void startPullingTask() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            this.taskStarter.submit(() -> {
                LOGGER.debug("[Config] config file group pulling task start");
                Random random = new Random();
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        TimeUnit.SECONDS.sleep(5 + random.nextInt(5));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.pullAll();
                }
            });
        }
        catch (Throwable t) {
            this.started.set(false);
        }
    }

    private void pullAll() {
        for (Map.Entry<com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata, RevisableConfigFileGroup> entry : this.configFileGroupCache.entrySet()) {
            com.tencent.polaris.configuration.api.core.ConfigFileGroupMetadata metadata = entry.getKey();
            RevisableConfigFileGroup oldRevisableConfigFileGroup = entry.getValue();
            String oldRevision = oldRevisableConfigFileGroup.getRevision();
            this.pullExecutorPool.submit(() -> {
                ConfigFileGroupMetadata metadataRPCObj = new ConfigFileGroupMetadata();
                metadataRPCObj.setFileGroupName(metadata.getFileGroupName());
                metadataRPCObj.setNamespace(metadata.getNamespace());
                ConfigFileGroupResponse response = this.rpcConnector.GetConfigFileMetadataList(metadataRPCObj, oldRevision);
                if (response == null) {
                    LOGGER.debug("[Config] pull empty response. namespace = {}, fileGroupName = {}, oldRevision = {}", new Object[]{metadata.getNamespace(), metadata.getFileGroupName(), oldRevision});
                    return;
                }
                LOGGER.debug("[Config] pull response. namespace = {}, fileGroupName = {}, oldRevision = {}, responseCode = {}", new Object[]{metadata.getNamespace(), metadata.getFileGroupName(), oldRevision, response.getCode()});
                switch (response.getCode()) {
                    case 200000: {
                        ConfigFileGroup configFileGroupObj = response.getConfigFileGroup();
                        String newRevision = response.getRevision();
                        List<ConfigFile> configFileList = configFileGroupObj.getConfigFileList();
                        ArrayList<ConfigFileMetadata> configFileMetadataList = new ArrayList<ConfigFileMetadata>();
                        for (ConfigFile configFile : configFileList) {
                            DefaultConfigFileMetadata configFileMetadata = new DefaultConfigFileMetadata(configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName());
                            configFileMetadataList.add(configFileMetadata);
                        }
                        if (this.configFileGroupCache.containsKey(metadata)) {
                            oldRevisableConfigFileGroup.updateConfigFileList(configFileMetadataList, newRevision);
                        }
                        LOGGER.info("[Config] pull result: success. namespace = {}, fileGroupName = {}, oldRevision = {}, newRevision = {}", new Object[]{metadata.getNamespace(), metadata.getFileGroupName(), oldRevision, newRevision});
                        return;
                    }
                    case 200001: {
                        LOGGER.debug("[Config] pull result: data no change. namespace = {}, fileGroupName = {}", (Object)metadata.getNamespace(), (Object)metadata.getFileGroupName());
                        return;
                    }
                    case 400202: {
                        LOGGER.warn("[Config] pull result: resource is empty. namespace = {}, fileGroupName = {}", (Object)metadata.getNamespace(), (Object)metadata.getFileGroupName());
                        if (this.configFileGroupCache.containsKey(metadata)) {
                            oldRevisableConfigFileGroup.updateConfigFileList(new ArrayList<ConfigFileMetadata>(), "");
                        }
                        return;
                    }
                }
            });
        }
    }
}

