/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configuration.connector.polaris;

import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.plugins.connector.grpc.ConnectionManager;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractPolarisConfigConnector
implements Plugin {
    protected ConnectionManager connectionManager;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public PluginType getType() {
        return PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        CompletableFuture readyFuture = new CompletableFuture();
        HashMap<ClusterType, CompletableFuture<String>> futures = new HashMap<ClusterType, CompletableFuture<String>>();
        futures.put(ClusterType.SERVICE_CONFIG_CLUSTER, readyFuture);
        this.connectionManager = new ConnectionManager(ctx, ctx.getConfig().getConfigFile().getServerConnector(), futures);
    }

    @Override
    public void postContextInit(Extensions extensions) throws PolarisException {
        this.connectionManager.setExtensions(extensions);
    }

    @Override
    public void destroy() {
        if (this.connectionManager != null) {
            this.connectionManager.destroy();
        }
    }
}

