/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.api;

import com.tencent.polaris.api.config.consumer.CircuitBreakerConfig;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.HalfOpenStatus;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.api.FunctionalDecorator;
import com.tencent.polaris.circuitbreak.api.InvokeHandler;
import com.tencent.polaris.circuitbreak.api.pojo.CheckResult;
import com.tencent.polaris.circuitbreak.api.pojo.FunctionalDecoratorRequest;
import com.tencent.polaris.circuitbreak.api.pojo.InvokeContext;
import com.tencent.polaris.circuitbreak.client.api.DefaultFunctionalDecorator;
import com.tencent.polaris.circuitbreak.client.api.DefaultInvokeHandler;
import com.tencent.polaris.circuitbreak.client.api.ServiceCallResultChecker;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import com.tencent.polaris.client.util.CommonValidator;
import java.util.List;

public class DefaultCircuitBreakAPI
extends BaseEngine
implements CircuitBreakAPI {
    private ServiceCallResultChecker checker;

    public DefaultCircuitBreakAPI(SDKContext sdkContext) {
        super(sdkContext);
    }

    protected void subInit() {
        CircuitBreakerConfig cbConfig = this.sdkContext.getConfig().getConsumer().getCircuitBreaker();
        if (!cbConfig.isEnable()) {
            return;
        }
        List serviceCallResultListeners = ServiceCallResultListener.getServiceCallResultListeners((SDKContext)this.sdkContext);
        for (ServiceCallResultListener listener : serviceCallResultListeners) {
            if (!(listener instanceof ServiceCallResultChecker)) continue;
            this.checker = (ServiceCallResultChecker)listener;
            break;
        }
    }

    protected void doDestroy() {
        if (null != this.checker) {
            this.checker.destroy();
        }
        super.doDestroy();
    }

    public CheckResult check(Resource resource) {
        return DefaultCircuitBreakAPI.check(resource, this.sdkContext.getExtensions());
    }

    public static CheckResult check(Resource resource, Extensions extensions) {
        CircuitBreaker circuitBreaker = extensions.getResourceBreaker();
        if (null == circuitBreaker) {
            return new CheckResult(true, "", null);
        }
        CircuitBreakerStatus circuitBreakerStatus = circuitBreaker.checkResource(resource);
        if (null != circuitBreakerStatus) {
            return DefaultCircuitBreakAPI.circuitBreakerStatusToResult(circuitBreakerStatus);
        }
        return new CheckResult(true, "", null);
    }

    private static CheckResult circuitBreakerStatusToResult(CircuitBreakerStatus circuitBreakerStatus) {
        CircuitBreakerStatus.Status status = circuitBreakerStatus.getStatus();
        if (status == CircuitBreakerStatus.Status.CLOSE) {
            return new CheckResult(true, circuitBreakerStatus.getCircuitBreaker(), circuitBreakerStatus.getFallbackInfo());
        }
        if (status == CircuitBreakerStatus.Status.OPEN) {
            return new CheckResult(false, circuitBreakerStatus.getCircuitBreaker(), circuitBreakerStatus.getFallbackInfo());
        }
        HalfOpenStatus halfOpenStatus = (HalfOpenStatus)circuitBreakerStatus;
        boolean allocated = halfOpenStatus.allocate();
        return new CheckResult(allocated, circuitBreakerStatus.getCircuitBreaker(), circuitBreakerStatus.getFallbackInfo());
    }

    public void report(ResourceStat reportStat) {
        DefaultCircuitBreakAPI.report(reportStat, this.sdkContext.getExtensions());
    }

    public static void report(ResourceStat reportStat, Extensions extensions) {
        CircuitBreaker circuitBreaker = extensions.getResourceBreaker();
        if (null == circuitBreaker) {
            return;
        }
        circuitBreaker.report(reportStat);
    }

    public FunctionalDecorator makeFunctionalDecorator(FunctionalDecoratorRequest makeDecoratorRequest) {
        CommonValidator.validateService((ServiceKey)makeDecoratorRequest.getService());
        CommonValidator.validateNamespaceService((String)makeDecoratorRequest.getService().getNamespace(), (String)makeDecoratorRequest.getService().getService());
        return new DefaultFunctionalDecorator(makeDecoratorRequest, this);
    }

    public InvokeHandler makeInvokeHandler(InvokeContext.RequestContext requestContext) {
        CommonValidator.validateService((ServiceKey)requestContext.getService());
        CommonValidator.validateNamespaceService((String)requestContext.getService().getNamespace(), (String)requestContext.getService().getService());
        return new DefaultInvokeHandler(requestContext, this);
    }
}

