/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.api;

import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.InstanceResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.SubsetResource;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.circuitbreak.client.api.DefaultCircuitBreakAPI;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import java.util.ArrayList;

public class InstanceCircuitBreakerReporter
implements ServiceCallResultListener {
    private Extensions extensions;

    public void init(SDKContext context) {
        this.extensions = context.getExtensions();
    }

    public void onServiceCallResult(InstanceGauge result) {
        ArrayList<Object> resources = new ArrayList<Object>(2);
        ServiceKey sourceService = null;
        if (null != result.getCallerService()) {
            sourceService = new ServiceKey(result.getCallerService().getNamespace(), result.getCallerService().getService());
        }
        ServiceKey serviceKey = new ServiceKey(result.getNamespace(), result.getService());
        resources.add(new InstanceResource(serviceKey, result.getHost(), result.getPort(), sourceService));
        if (StringUtils.isNotBlank((String)result.getSubset())) {
            resources.add(new SubsetResource(serviceKey, result.getSubset(), result.getSubsetMetadata(), sourceService));
        }
        int retCode = 0;
        if (null != result.getRetCode()) {
            retCode = result.getRetCode();
        }
        long delay = 0L;
        if (null != result.getDelay()) {
            delay = result.getDelay();
        }
        RetStatus retStatus = RetStatus.RetUnknown;
        if (null != result.getRetStatus()) {
            retStatus = result.getRetStatus();
        }
        for (Resource resource : resources) {
            ResourceStat resourceStat = new ResourceStat(resource, retCode, delay, retStatus);
            DefaultCircuitBreakAPI.report(resourceStat, this.extensions);
        }
    }

    public void destroy() {
    }
}

