/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.api;

import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.InstanceResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.circuitbreak.client.api.DefaultCircuitBreakAPI;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;

public class InstanceCircuitBreakerReporter
implements ServiceCallResultListener {
    private Extensions extensions;

    public void init(SDKContext context) {
        this.extensions = context.getExtensions();
    }

    public void onServiceCallResult(InstanceGauge result) {
        if (!InstanceCircuitBreakerReporter.needReportStat(result)) {
            return;
        }
        ServiceKey sourceService = null;
        if (null != result.getCallerService()) {
            sourceService = new ServiceKey(result.getCallerService().getNamespace(), result.getCallerService().getService());
        }
        ServiceKey serviceKey = new ServiceKey(result.getNamespace(), result.getService());
        InstanceResource resource = new InstanceResource(serviceKey, result.getHost(), result.getPort(), sourceService, result.getProtocol());
        int retCode = 0;
        if (null != result.getRetCode()) {
            retCode = result.getRetCode();
        }
        long delay = 0L;
        if (null != result.getDelay()) {
            delay = result.getDelay();
        }
        RetStatus retStatus = RetStatus.RetUnknown;
        if (null != result.getRetStatus()) {
            retStatus = result.getRetStatus();
        }
        ResourceStat resourceStat = new ResourceStat((Resource)resource, retCode, delay, retStatus);
        DefaultCircuitBreakAPI.report(resourceStat, this.extensions);
    }

    private static boolean needReportStat(InstanceGauge result) {
        if (StringUtils.isBlank((String)result.getService()) || StringUtils.isBlank((String)result.getNamespace())) {
            return false;
        }
        return !StringUtils.equals((String)result.getNamespace(), (String)"Polaris") || !StringUtils.equals((String)result.getService(), (String)"polaris.builtin");
    }

    public void destroy() {
    }
}

