/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.task;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.plugin.registry.InstanceProperty;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.plugin.registry.ServiceUpdateRequest;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.client.pojo.InstanceByProto;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class InstancesDetectTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(InstancesDetectTask.class);
    private final Extensions extensions;
    private final OutlierDetectionConfig.When when;
    private final AtomicBoolean destroy = new AtomicBoolean(false);

    public InstancesDetectTask(Extensions extensions, OutlierDetectionConfig.When when) {
        this.extensions = extensions;
        this.when = when;
    }

    @Override
    public void run() {
        Set services = this.extensions.getLocalRegistry().getServices();
        for (ServiceKey serviceKey : services) {
            if (Objects.equals(serviceKey.getNamespace(), "Polaris")) continue;
            try {
                this.doInstanceDetectForService(serviceKey);
            }
            catch (PolarisException e) {
                LOG.error("fail to do instance detect for {}, e:{}", (Object)serviceKey, (Object)e);
            }
        }
    }

    public void destroy() {
        this.destroy.set(true);
    }

    private void doInstanceDetectForService(ServiceKey serviceKey) throws PolarisException {
        ServiceEventKey svcEventKey = new ServiceEventKey(serviceKey, ServiceEventKey.EventType.INSTANCE);
        ServiceInstances instances = this.extensions.getLocalRegistry().getInstances(new ResourceFilter(svcEventKey, true, true));
        if (!instances.isInitialized() || instances.getInstances().size() == 0) {
            return;
        }
        HashMap<Instance, DetectResult> aliveResults = new HashMap<Instance, DetectResult>();
        for (Instance instance : instances.getInstances()) {
            DetectResult result;
            if (this.destroy.get()) break;
            if (this.when == OutlierDetectionConfig.When.on_recover && instance.getCircuitBreakerStatus().getStatus() != CircuitBreakerStatus.Status.OPEN || (result = this.detectInstance(instance)) == null) continue;
            aliveResults.put(instance, result);
        }
        if (MapUtils.isNotEmpty(aliveResults)) {
            ServiceUpdateRequest updateRequest = this.buildInstanceUpdateResult(serviceKey, aliveResults);
            LOG.debug("update cache for outlier detect, value is {}", (Object)updateRequest);
            this.extensions.getLocalRegistry().updateInstances(updateRequest);
        }
    }

    private ServiceUpdateRequest buildInstanceUpdateResult(ServiceKey serviceKey, Map<Instance, DetectResult> aliveResults) {
        ArrayList<InstanceProperty> instances = new ArrayList<InstanceProperty>();
        int notChange = 0;
        for (Map.Entry<Instance, DetectResult> entry : aliveResults.entrySet()) {
            InstanceByProto instance = (InstanceByProto)entry.getKey();
            DetectResult detectResult = instance.getDetectResult();
            if (detectResult != null && detectResult.getRetStatus() == entry.getValue().getRetStatus()) {
                ++notChange;
                continue;
            }
            HashMap<String, DetectResult> properties = new HashMap<String, DetectResult>();
            properties.put("detectResult", entry.getValue());
            InstanceProperty instanceProperty = new InstanceProperty(entry.getKey(), properties);
            instances.add(instanceProperty);
        }
        LOG.info("{} detect {} instances, update {}", new Object[]{serviceKey, aliveResults.size(), aliveResults.size() - notChange});
        return new ServiceUpdateRequest(serviceKey, instances);
    }

    private DetectResult detectInstance(Instance instance) throws PolarisException {
        DetectResult result = null;
        for (HealthChecker detector : this.extensions.getHealthCheckers()) {
            DetectResult pluginResult = detector.detectInstance(instance, null);
            if (pluginResult == null || (result = pluginResult).getRetStatus() != RetStatus.RetSuccess) continue;
            result.setDetectType(detector.getName());
            return result;
        }
        if (result != null) {
            result.setDetectType("all");
        }
        return result;
    }
}

