/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.api;

import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.MethodResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.ServiceResource;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.api.InvokeHandler;
import com.tencent.polaris.circuitbreak.api.pojo.CheckResult;
import com.tencent.polaris.circuitbreak.api.pojo.InvokeContext;
import com.tencent.polaris.circuitbreak.api.pojo.ResultToErrorCode;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;

public class DefaultInvokeHandler
implements InvokeHandler {
    private final CircuitBreakAPI circuitBreakAPI;
    private final InvokeContext.RequestContext requestContext;

    public DefaultInvokeHandler(InvokeContext.RequestContext requestContext, CircuitBreakAPI circuitBreakAPI) {
        this.requestContext = requestContext;
        this.circuitBreakAPI = circuitBreakAPI;
    }

    public void acquirePermission() {
        CheckResult check = this.commonCheck(this.requestContext);
        if (check != null) {
            throw new CallAbortedException(check.getRuleName(), check.getFallbackInfo());
        }
    }

    public void onSuccess(InvokeContext.ResponseContext responseContext) {
        long delay = responseContext.getDurationUnit().toMillis(responseContext.getDuration());
        ResultToErrorCode resultToErrorCode = this.requestContext.getResultToErrorCode();
        int code = 0;
        RetStatus retStatus = RetStatus.RetUnknown;
        if (null != resultToErrorCode) {
            code = resultToErrorCode.onSuccess(responseContext.getResult());
        }
        this.commonReport(this.requestContext, delay, code, retStatus);
    }

    public void onError(InvokeContext.ResponseContext responseContext) {
        long delay = responseContext.getDurationUnit().toMillis(responseContext.getDuration());
        ResultToErrorCode resultToErrorCode = this.requestContext.getResultToErrorCode();
        int code = -1;
        RetStatus retStatus = RetStatus.RetUnknown;
        if (null != resultToErrorCode) {
            code = resultToErrorCode.onError(responseContext.getError());
        }
        if (responseContext.getError() instanceof CallAbortedException) {
            retStatus = RetStatus.RetReject;
        }
        this.commonReport(this.requestContext, delay, code, retStatus);
    }

    private CheckResult commonCheck(InvokeContext.RequestContext requestContext) {
        MethodResource methodResource;
        ServiceResource svcResource = new ServiceResource(requestContext.getService(), requestContext.getSourceService());
        CheckResult check = this.circuitBreakAPI.check((Resource)svcResource);
        if (!check.isPass()) {
            return check;
        }
        if (StringUtils.isNotBlank((String)requestContext.getMethod()) && !(check = this.circuitBreakAPI.check((Resource)(methodResource = new MethodResource(requestContext.getService(), requestContext.getMethod(), requestContext.getSourceService())))).isPass()) {
            return check;
        }
        return null;
    }

    private void commonReport(InvokeContext.RequestContext requestContext, long delayMills, int code, RetStatus retStatus) {
        ServiceResource svcResource = new ServiceResource(requestContext.getService(), requestContext.getSourceService());
        ResourceStat resourceStat = new ResourceStat((Resource)svcResource, code, delayMills, retStatus);
        this.circuitBreakAPI.report(resourceStat);
        if (StringUtils.isNotBlank((String)requestContext.getMethod())) {
            MethodResource methodResource = new MethodResource(requestContext.getService(), requestContext.getMethod(), requestContext.getSourceService());
            resourceStat = new ResourceStat((Resource)methodResource, code, delayMills, retStatus);
            this.circuitBreakAPI.report(resourceStat);
        }
    }
}

