/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.flow;

import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.circuitbreak.api.flow.CircuitBreakerFlow;
import com.tencent.polaris.circuitbreak.api.pojo.CheckResult;
import com.tencent.polaris.client.api.SDKContext;

public class DefaultCircuitBreakerFlow
implements CircuitBreakerFlow {
    private SDKContext sdkContext;

    public String getName() {
        return "default";
    }

    public void setSDKContext(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
    }

    public CheckResult check(Resource resource) {
        return DefaultCircuitBreakerFlow.check(resource, this.sdkContext.getExtensions());
    }

    private static CheckResult circuitBreakerStatusToResult(CircuitBreakerStatus circuitBreakerStatus) {
        CircuitBreakerStatus.Status status = circuitBreakerStatus.getStatus();
        if (status == CircuitBreakerStatus.Status.OPEN) {
            return new CheckResult(false, circuitBreakerStatus.getCircuitBreaker(), circuitBreakerStatus.getFallbackInfo());
        }
        return new CheckResult(true, circuitBreakerStatus.getCircuitBreaker(), circuitBreakerStatus.getFallbackInfo());
    }

    private static CheckResult check(Resource resource, Extensions extensions) {
        CircuitBreaker circuitBreaker = extensions.getResourceBreaker();
        if (null == circuitBreaker) {
            return new CheckResult(true, "", null);
        }
        CircuitBreakerStatus circuitBreakerStatus = circuitBreaker.checkResource(resource);
        if (null != circuitBreakerStatus) {
            return DefaultCircuitBreakerFlow.circuitBreakerStatusToResult(circuitBreakerStatus);
        }
        return new CheckResult(true, "", null);
    }

    private static void report(ResourceStat reportStat, Extensions extensions) {
        CircuitBreaker circuitBreaker = extensions.getResourceBreaker();
        if (null == circuitBreaker) {
            return;
        }
        circuitBreaker.report(reportStat);
    }

    public void report(ResourceStat reportStat) {
        DefaultCircuitBreakerFlow.report(reportStat, this.sdkContext.getExtensions());
    }
}

