/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.task;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.plugin.registry.InstanceProperty;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.plugin.registry.ServiceUpdateRequest;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.OutlierDetectionStatus;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancesDetectTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(InstancesDetectTask.class);
    private final Extensions extensions;
    private final AtomicBoolean destroy = new AtomicBoolean(false);

    public InstancesDetectTask(Extensions extensions) {
        this.extensions = extensions;
    }

    @Override
    public void run() {
        Set services = this.extensions.getLocalRegistry().getServices();
        for (ServiceKey serviceKey : services) {
            try {
                this.doInstanceDetectForService(serviceKey);
            }
            catch (PolarisException e) {
                LOG.error("fail to do instance detect for {}, e:{}", (Object)serviceKey, (Object)e);
            }
        }
    }

    public void destroy() {
        this.destroy.set(true);
    }

    private void doInstanceDetectForService(ServiceKey serviceKey) throws PolarisException {
        ServiceEventKey svcEventKey = new ServiceEventKey(serviceKey, ServiceEventKey.EventType.INSTANCE);
        ServiceInstances instances = this.extensions.getLocalRegistry().getInstances(new ResourceFilter(svcEventKey, true, true));
        if (!instances.isInitialized() || instances.getInstances().size() == 0) {
            return;
        }
        HashMap<Instance, DetectResult> aliveResults = new HashMap<Instance, DetectResult>();
        for (Instance instance : instances.getInstances()) {
            if (this.destroy.get()) break;
            DetectResult result = this.detectInstance(instance);
            if (result == null || result.getRetStatus() != RetStatus.RetSuccess) continue;
            aliveResults.put(instance, result);
        }
        if (MapUtils.isNotEmpty(aliveResults)) {
            ServiceUpdateRequest updateRequest = this.buildInstanceUpdateResult(serviceKey, aliveResults);
            LOG.info("update cache for outlier detect, value is {}", (Object)updateRequest);
            this.extensions.getLocalRegistry().updateInstances(updateRequest);
        }
    }

    private ServiceUpdateRequest buildInstanceUpdateResult(ServiceKey serviceKey, Map<Instance, DetectResult> aliveResults) {
        ArrayList<InstanceProperty> instances = new ArrayList<InstanceProperty>();
        for (Map.Entry<Instance, DetectResult> entry : aliveResults.entrySet()) {
            HashMap<String, OutlierDetectionStatus> properties = new HashMap<String, OutlierDetectionStatus>();
            properties.put("detectResult", new OutlierDetectionStatus(entry.getValue().getDetectType(), OutlierDetectionStatus.Status.HEALTHY, entry.getValue().getLastDetectTime().getTime()));
            InstanceProperty instanceProperty = new InstanceProperty(entry.getKey(), properties);
            instances.add(instanceProperty);
        }
        return new ServiceUpdateRequest(serviceKey, instances);
    }

    private DetectResult detectInstance(Instance instance) throws PolarisException {
        for (HealthChecker detector : this.extensions.getHealthCheckers()) {
            DetectResult result = detector.detectInstance(instance);
            if (result == null || result.getRetStatus() != RetStatus.RetSuccess) continue;
            return result;
        }
        return null;
    }
}

