/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.api;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.global.ClusterConfig;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.config.global.SystemConfig;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Manager;
import com.tencent.polaris.api.plugin.Supplier;
import com.tencent.polaris.api.plugin.TypeProvider;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.ServerServiceInfo;
import com.tencent.polaris.api.plugin.impl.PluginManager;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.logging.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class SDKContext
extends Destroyable
implements InitContext,
AutoCloseable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SDKContext.class);
    private static final String DEFAULT_ADDRESS = "127.0.0.1";
    private final Configuration configuration;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Manager plugins;
    private final ValueContext valueContext;
    private final Extensions extensions = new Extensions();
    private final Object lock = new Object();
    private final List<Destroyable> destroyHooks = new ArrayList<Destroyable>();
    private final Collection<ServerServiceInfo> serverServices;

    public SDKContext(Configuration configuration, Manager plugins, ValueContext valueContext) {
        ClusterConfig monitorCluster;
        ClusterConfig healthCheckCluster;
        ClusterConfig configCluster;
        this.configuration = configuration;
        this.plugins = plugins;
        this.valueContext = valueContext;
        this.valueContext.setClientId(SDKContext.generateClientId(this.valueContext.getHost()));
        ArrayList<ServerServiceInfo> services = new ArrayList<ServerServiceInfo>();
        SystemConfig system = configuration.getGlobal().getSystem();
        ClusterConfig discoverCluster = system.getDiscoverCluster();
        if (this.clusterAvailable(discoverCluster)) {
            services.add(new ServerServiceInfo(ClusterType.SERVICE_DISCOVER_CLUSTER, discoverCluster));
        }
        if (this.clusterAvailable(configCluster = system.getConfigCluster())) {
            services.add(new ServerServiceInfo(ClusterType.SERVICE_CONFIG_CLUSTER, configCluster));
        }
        if (this.clusterAvailable(healthCheckCluster = system.getHealthCheckCluster())) {
            services.add(new ServerServiceInfo(ClusterType.HEALTH_CHECK_CLUSTER, healthCheckCluster));
        }
        if (this.clusterAvailable(monitorCluster = system.getMonitorCluster())) {
            services.add(new ServerServiceInfo(ClusterType.MONITOR_CLUSTER, monitorCluster));
        }
        this.serverServices = Collections.unmodifiableCollection(services);
    }

    private static String generateClientId(String host) {
        return host + "-" + SDKContext.getProcessId("0");
    }

    private static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static SDKContext initContext() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return SDKContext.initContextByConfig(configuration);
    }

    public static SDKContext initContextByConfig(Configuration config) throws PolarisException {
        try {
            ((ConfigurationImpl)config).setDefault();
            config.verify();
        }
        catch (IllegalArgumentException e) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, "fail to verify configuration", (Throwable)e);
        }
        ServiceLoader<TypeProvider> providers = ServiceLoader.load(TypeProvider.class);
        ArrayList types = new ArrayList();
        for (TypeProvider provider : providers) {
            types.addAll(provider.getTypes());
        }
        PluginManager manager = new PluginManager(types);
        ValueContext valueContext = new ValueContext();
        valueContext.setHost(SDKContext.parseHost(config));
        valueContext.setServerConnectorProtocol(SDKContext.parseServerConnectorProtocol(config));
        SDKContext initContext = new SDKContext(config, (Manager)manager, valueContext);
        try {
            manager.initPlugins((InitContext)initContext);
        }
        catch (Throwable e) {
            manager.destroyPlugins();
            if (e instanceof PolarisException) {
                throw e;
            }
            throw new PolarisException(ErrorCode.PLUGIN_ERROR, "plugin error", e);
        }
        return initContext;
    }

    public static String parseHost(Configuration configuration) {
        String hostAddress = configuration.getGlobal().getAPI().getBindIP();
        if (!StringUtils.isBlank((String)hostAddress)) {
            return hostAddress;
        }
        String nic = configuration.getGlobal().getAPI().getBindIf();
        if (StringUtils.isNotBlank((String)nic)) {
            return SDKContext.resolveAddress(nic);
        }
        try {
            return SDKContext.getHostByDial(configuration);
        }
        catch (IOException e) {
            LOG.error("[ReportClient]get address by dial failed", (Throwable)e);
            return DEFAULT_ADDRESS;
        }
    }

    public static String parseServerConnectorProtocol(Configuration configuration) {
        String protocol = CollectionUtils.isNotEmpty((Collection)configuration.getGlobal().getServerConnectors()) ? "composite" : configuration.getGlobal().getServerConnector().getProtocol();
        return protocol;
    }

    private static String getHostByDial(Configuration configuration) throws IOException {
        String serverAddress = CollectionUtils.isNotEmpty((Collection)configuration.getGlobal().getServerConnectors()) ? (String)((ServerConnectorConfigImpl)configuration.getGlobal().getServerConnectors().get(0)).getAddresses().get(0) : (String)configuration.getGlobal().getServerConnector().getAddresses().get(0);
        URL url = new URL(serverAddress);
        try (Socket socket = new Socket(url.getHost(), url.getPort());){
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
    }

    private static NetworkInterface resolveNetworkInterface(String nic) {
        NetworkInterface ni = null;
        try {
            ni = NetworkInterface.getByName(nic);
        }
        catch (SocketException e) {
            LOG.error("[ReportClient]get nic failed, nic:{}", (Object)nic, (Object)e);
        }
        if (null != ni) {
            return ni;
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.getInetAddresses().hasMoreElements()) continue;
                return networkInterface;
            }
        }
        catch (SocketException e) {
            LOG.error("[ReportClient]get all network interfaces failed", (Throwable)e);
        }
        return null;
    }

    private static String resolveAddress(String nic) {
        NetworkInterface ni = SDKContext.resolveNetworkInterface(nic);
        if (null == ni) {
            return DEFAULT_ADDRESS;
        }
        Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
        if (inetAddresses.hasMoreElements()) {
            InetAddress inetAddress = inetAddresses.nextElement();
            return inetAddress.getCanonicalHostName();
        }
        return DEFAULT_ADDRESS;
    }

    public synchronized void init() throws PolarisException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        this.extensions.init(this.configuration, (Supplier)this.plugins, this.valueContext);
        this.plugins.postContextInitPlugins(this.extensions);
    }

    private boolean clusterAvailable(ClusterConfig clusterConfig) {
        if (null == clusterConfig) {
            return false;
        }
        if (StringUtils.isBlank((String)clusterConfig.getNamespace()) || StringUtils.isBlank((String)clusterConfig.getService())) {
            return false;
        }
        return !clusterConfig.isSameAsBuiltin();
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Supplier getPlugins() {
        return this.plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDestroy() {
        Object object = this.lock;
        synchronized (object) {
            for (Destroyable destroyable : this.destroyHooks) {
                destroyable.destroy();
            }
        }
        this.plugins.destroyPlugins();
    }

    public ValueContext getValueContext() {
        return this.valueContext;
    }

    public Collection<ServerServiceInfo> getServerServices() {
        return this.serverServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestroyHook(Destroyable destroyable) {
        Object object = this.lock;
        synchronized (object) {
            this.destroyHooks.add(destroyable);
        }
    }

    @Override
    public void close() {
        this.destroy();
    }
}

