/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.api;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.client.api.SDKContext;

public abstract class BaseEngine
extends Destroyable {
    protected final SDKContext sdkContext;

    public BaseEngine(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
    }

    public void init() throws PolarisException {
        this.sdkContext.init();
        this.subInit();
    }

    public SDKContext getSDKContext() {
        return this.sdkContext;
    }

    protected abstract void subInit() throws PolarisException;

    protected void checkAvailable(String apiName) throws PolarisException {
        if (this.isDestroyed()) {
            throw new PolarisException(ErrorCode.INVALID_STATE, String.format("%s: api instance has been destroyed", apiName));
        }
    }

    protected long getTimeout(RequestBaseEntity entity) {
        return entity.getTimeoutMs() == 0L ? this.sdkContext.getConfig().getGlobal().getAPI().getTimeout() : entity.getTimeoutMs();
    }

    protected void doDestroy() {
        this.sdkContext.doDestroy();
    }
}

