/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.flow;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.registry.EventCompleteNotifier;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class GetResourcesInvoker
implements EventCompleteNotifier,
Future<ResourcesResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(GetResourcesInvoker.class);
    private final ResourcesResponse resourcesResponse = new ResourcesResponse();
    private final Set<ServiceEventKey> listeningServices = new HashSet<ServiceEventKey>();
    private final int totalCallback;
    private final AtomicInteger responseIncrement = new AtomicInteger();
    private final Object notifier = new Object();
    private final Extensions extensions;
    private final boolean internalRequest;
    private final boolean useCache;

    public GetResourcesInvoker(ServiceEventKeysProvider paramProvider, Extensions extensions, boolean internalRequest, boolean useCache) throws PolarisException {
        this.extensions = extensions;
        this.internalRequest = internalRequest;
        this.totalCallback = this.init(paramProvider);
        this.useCache = useCache;
    }

    private int init(ServiceEventKeysProvider paramProvider) throws PolarisException {
        LocalRegistry localRegistry = this.extensions.getLocalRegistry();
        int callbacks = 0;
        if (!CollectionUtils.isEmpty((Collection)paramProvider.getSvcEventKeys())) {
            for (ServiceEventKey svcEventKey : paramProvider.getSvcEventKeys()) {
                this.listeningServices.add(svcEventKey);
                callbacks = this.processSvcEventKey(localRegistry, callbacks, svcEventKey);
            }
        }
        if (null != paramProvider.getSvcEventKey()) {
            this.listeningServices.add(paramProvider.getSvcEventKey());
            callbacks = this.processSvcEventKey(localRegistry, callbacks, paramProvider.getSvcEventKey());
        }
        return callbacks;
    }

    private int processSvcEventKey(LocalRegistry localRegistry, int callbacks, ServiceEventKey svcEventKey) {
        ResourceFilter filter = new ResourceFilter(svcEventKey, this.internalRequest, this.useCache);
        switch (svcEventKey.getEventType()) {
            case INSTANCE: {
                ServiceInstances instances = localRegistry.getInstances(filter);
                if (instances.isInitialized()) {
                    this.resourcesResponse.addServiceInstances(svcEventKey, instances);
                    break;
                }
                localRegistry.loadInstances(svcEventKey, (EventCompleteNotifier)this);
                ++callbacks;
                break;
            }
            case SERVICE: {
                Services services = localRegistry.getServices(filter);
                if (services.isInitialized()) {
                    this.resourcesResponse.addServices(svcEventKey, services);
                    break;
                }
                localRegistry.loadServices(svcEventKey, (EventCompleteNotifier)this);
                ++callbacks;
                break;
            }
            default: {
                ServiceRule serviceRule = localRegistry.getServiceRule(filter);
                if (serviceRule.isInitialized()) {
                    this.resourcesResponse.addServiceRule(svcEventKey, serviceRule);
                    break;
                }
                localRegistry.loadServiceRule(svcEventKey, (EventCompleteNotifier)this);
                ++callbacks;
            }
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(ServiceEventKey svcEventKey) {
        LocalRegistry localRegistry = this.extensions.getLocalRegistry();
        ResourceFilter filter = new ResourceFilter(svcEventKey, this.internalRequest, this.useCache);
        if (svcEventKey.getEventType() == ServiceEventKey.EventType.INSTANCE) {
            ServiceInstances instances = localRegistry.getInstances(filter);
            this.resourcesResponse.addServiceInstances(svcEventKey, instances);
        } else if (svcEventKey.getEventType() == ServiceEventKey.EventType.SERVICE) {
            Services services = localRegistry.getServices(filter);
            this.resourcesResponse.addServices(svcEventKey, services);
        } else {
            ServiceRule serviceRule = localRegistry.getServiceRule(filter);
            this.resourcesResponse.addServiceRule(svcEventKey, serviceRule);
        }
        Object object = this.notifier;
        synchronized (object) {
            int curTotal = this.responseIncrement.addAndGet(1);
            if (this.totalCallback == curTotal) {
                this.notifier.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeExceptionally(ServiceEventKey svcEventKey, Throwable throwable) {
        this.resourcesResponse.addError(svcEventKey, throwable);
        Object object = this.notifier;
        synchronized (object) {
            int curTotal = this.responseIncrement.addAndGet(1);
            if (this.totalCallback == curTotal) {
                this.notifier.notifyAll();
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.totalCallback == 0 || this.responseIncrement.get() >= this.totalCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourcesResponse get() throws InterruptedException, ExecutionException {
        Map<ServiceEventKey, Throwable> errors;
        if (!this.isDone()) {
            Object object = this.notifier;
            synchronized (object) {
                if (!this.isDone()) {
                    this.notifier.wait();
                }
            }
        }
        if (!(errors = this.resourcesResponse.getErrors()).isEmpty()) {
            throw new ExecutionException((Throwable)this.combineErrors(errors.values()));
        }
        return this.resourcesResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourcesResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Map<ServiceEventKey, Throwable> errors;
        long timeoutMs = TimeUnit.MILLISECONDS.convert(timeout, unit);
        if (!this.isDone()) {
            Object object = this.notifier;
            synchronized (object) {
                if (!this.isDone()) {
                    LOG.debug("start to wait for {}", this.listeningServices);
                    this.notifier.wait(timeoutMs);
                }
                LOG.debug("end to wait for {}", this.listeningServices);
                if (!this.isDone()) {
                    LOG.debug("timeout to wait for {}", this.listeningServices);
                    throw new TimeoutException();
                }
            }
        }
        if (!(errors = this.resourcesResponse.getErrors()).isEmpty()) {
            throw new ExecutionException((Throwable)this.combineErrors(errors.values()));
        }
        return this.resourcesResponse;
    }

    private PolarisException combineErrors(Collection<Throwable> errors) {
        StringBuilder builder = new StringBuilder();
        int retryCount = 0;
        for (Throwable err : errors) {
            if (err instanceof RetriableException) {
                ++retryCount;
            }
            builder.append(err.toString());
            builder.append("\n");
        }
        if (retryCount == errors.size()) {
            return new RetriableException(ErrorCode.SERVER_USER_ERROR, builder.toString());
        }
        return new PolarisException(ErrorCode.SERVER_USER_ERROR, builder.toString());
    }

    public static interface ResourcesListener {
        public void onComplete(ResourcesResponse var1);
    }
}

