/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.api;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.server.TargetServer;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.List;
import org.slf4j.Logger;

public abstract class BaseEngine
extends Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseEngine.class);
    private static final String CTX_KEY_ENGINE = "key_engine";
    protected final SDKContext sdkContext;
    private List<ServiceCallResultListener> serviceCallResultListeners;

    public BaseEngine(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
    }

    public void init() throws PolarisException {
        this.sdkContext.init();
        this.subInit();
        this.serviceCallResultListeners = ServiceCallResultListener.getServiceCallResultListeners(this.sdkContext);
        this.sdkContext.getValueContext().setValue(CTX_KEY_ENGINE, (Object)this);
    }

    public SDKContext getSDKContext() {
        return this.sdkContext;
    }

    protected abstract void subInit() throws PolarisException;

    protected void checkAvailable(String apiName) throws PolarisException {
        this.checkAvailable(apiName, true);
    }

    protected boolean checkAvailable(String apiName, boolean withException) {
        if (this.isDestroyed()) {
            String errMsg = String.format("%s: api instance has been destroyed", apiName);
            if (withException) {
                throw new PolarisException(ErrorCode.INVALID_STATE, errMsg);
            }
            LOGGER.error(errMsg);
            return false;
        }
        return true;
    }

    protected long getTimeout(RequestBaseEntity entity) {
        return entity.getTimeoutMs() == 0L ? this.sdkContext.getConfig().getGlobal().getAPI().getTimeout() : entity.getTimeoutMs();
    }

    protected void reportInvokeStat(ServiceCallResult req) throws PolarisException {
        for (ServiceCallResultListener listener : this.serviceCallResultListeners) {
            listener.onServiceCallResult((InstanceGauge)req);
        }
    }

    protected void doDestroy() {
        this.sdkContext.doDestroy();
    }

    public static BaseEngine getEngine(ValueContext valueContext) {
        return (BaseEngine)((Object)valueContext.getValue(CTX_KEY_ENGINE));
    }

    public void reportServerCall(ServiceCallResult serviceCallResult, TargetServer targetServer, String method) {
        if (null != targetServer) {
            serviceCallResult.setNamespace(targetServer.getServiceKey().getNamespace());
            serviceCallResult.setService(targetServer.getServiceKey().getService());
            serviceCallResult.setHost(targetServer.getHost());
            serviceCallResult.setPort(targetServer.getPort());
            serviceCallResult.setLabels(targetServer.getLabels());
        }
        serviceCallResult.setMethod(method);
        this.reportInvokeStat(serviceCallResult);
    }
}

