/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.global.ClusterConfig;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.config.global.SystemConfig;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Manager;
import com.tencent.polaris.api.plugin.Supplier;
import com.tencent.polaris.api.plugin.TypeProvider;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.ServerServiceInfo;
import com.tencent.polaris.api.plugin.impl.PluginManager;
import com.tencent.polaris.api.plugin.server.ReportClientRequest;
import com.tencent.polaris.api.plugin.server.ReportClientResponse;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.plugin.stat.ReporterMetaInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.IPAddressUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.AbstractFlow;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.logging.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class SDKContext
extends Destroyable
implements InitContext,
AutoCloseable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SDKContext.class);
    private static final String DEFAULT_ADDRESS = "127.0.0.1";
    private static final AtomicInteger CLIENT_ID_SEQ = new AtomicInteger(0);
    private final Configuration configuration;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Manager plugins;
    private final ValueContext valueContext;
    private final Extensions extensions = new Extensions();
    private final Object lock = new Object();
    private final List<Destroyable> destroyHooks = new ArrayList<Destroyable>();
    private final Collection<ServerServiceInfo> serverServices;
    private final ScheduledExecutorService reportClientExecutorService;

    public SDKContext(Configuration configuration, Manager plugins, ValueContext valueContext) {
        ClusterConfig monitorCluster;
        ClusterConfig healthCheckCluster;
        ClusterConfig configCluster;
        this.configuration = configuration;
        this.plugins = plugins;
        this.valueContext = valueContext;
        this.valueContext.setClientId(SDKContext.generateClientId(SDKContext.getHostNameOrDefaultToHost(this.valueContext.getHost())));
        LOG.info("init SDKContext with clientId={}", (Object)this.valueContext.getClientId());
        ArrayList<ServerServiceInfo> services = new ArrayList<ServerServiceInfo>();
        SystemConfig system = configuration.getGlobal().getSystem();
        ClusterConfig discoverCluster = system.getDiscoverCluster();
        if (this.clusterAvailable(discoverCluster)) {
            services.add(new ServerServiceInfo(ClusterType.SERVICE_DISCOVER_CLUSTER, discoverCluster));
        }
        if (this.clusterAvailable(configCluster = system.getConfigCluster())) {
            services.add(new ServerServiceInfo(ClusterType.SERVICE_CONFIG_CLUSTER, configCluster));
        }
        if (this.clusterAvailable(healthCheckCluster = system.getHealthCheckCluster())) {
            services.add(new ServerServiceInfo(ClusterType.HEALTH_CHECK_CLUSTER, healthCheckCluster));
        }
        if (this.clusterAvailable(monitorCluster = system.getMonitorCluster())) {
            services.add(new ServerServiceInfo(ClusterType.MONITOR_CLUSTER, monitorCluster));
        }
        this.serverServices = Collections.unmodifiableCollection(services);
        this.reportClientExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("polaris-report-client"));
    }

    private static String generateClientId(String host) {
        if (!StringUtils.equalsIgnoreCase((String)host, (String)DEFAULT_ADDRESS)) {
            return host + "_" + SDKContext.getProcessId("0") + "_" + CLIENT_ID_SEQ.getAndIncrement();
        }
        return UUID.randomUUID().toString();
    }

    private static String getHostNameOrDefaultToHost(String host) {
        try {
            String hostName = IPAddressUtils.getHostName();
            if (StringUtils.isBlank((String)hostName)) {
                hostName = host;
            }
            return hostName;
        }
        catch (Throwable throwable) {
            LOG.error("fail to get host name", throwable);
            return host;
        }
    }

    private static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static SDKContext initContext() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return SDKContext.initContextByConfig(configuration);
    }

    public static SDKContext initContextByConfig(Configuration config) throws PolarisException {
        try {
            ((ConfigurationImpl)config).setDefault();
            config.verify();
            JsonMapper mapper = new JsonMapper();
            LOG.info("SDKContext config {} ", (Object)mapper.writeValueAsString((Object)config));
        }
        catch (IllegalArgumentException e) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, "fail to verify configuration", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            // empty catch block
        }
        ServiceLoader<TypeProvider> providers = ServiceLoader.load(TypeProvider.class);
        ArrayList types = new ArrayList();
        for (TypeProvider provider : providers) {
            types.addAll(provider.getTypes());
        }
        PluginManager manager = new PluginManager(types);
        ValueContext valueContext = new ValueContext();
        valueContext.setHost(SDKContext.parseHost(config));
        valueContext.setServerConnectorProtocol(SDKContext.parseServerConnectorProtocol(config));
        SDKContext initContext = new SDKContext(config, (Manager)manager, valueContext);
        try {
            manager.initPlugins((InitContext)initContext);
        }
        catch (Throwable e) {
            manager.destroyPlugins();
            if (e instanceof PolarisException) {
                throw e;
            }
            throw new PolarisException(ErrorCode.PLUGIN_ERROR, "plugin error", e);
        }
        return initContext;
    }

    public static String parseHost(Configuration configuration) {
        String hostAddress = configuration.getGlobal().getAPI().getBindIP();
        if (!StringUtils.isBlank((String)hostAddress)) {
            return hostAddress;
        }
        String nic = configuration.getGlobal().getAPI().getBindIf();
        if (StringUtils.isNotBlank((String)nic)) {
            return SDKContext.resolveAddress(nic);
        }
        try {
            return SDKContext.getHostByDial(configuration);
        }
        catch (IOException e) {
            LOG.info("[ReportClient]get address by dial failed: {}", (Object)e.getMessage());
            return DEFAULT_ADDRESS;
        }
    }

    public static String parseServerConnectorProtocol(Configuration configuration) {
        String protocol = CollectionUtils.isNotEmpty((Collection)configuration.getGlobal().getServerConnectors()) ? "composite" : configuration.getGlobal().getServerConnector().getProtocol();
        return protocol;
    }

    private static String getHostByDial(Configuration configuration) throws IOException {
        String serverAddress = CollectionUtils.isNotEmpty((Collection)configuration.getGlobal().getServerConnectors()) ? (String)((ServerConnectorConfigImpl)configuration.getGlobal().getServerConnectors().get(0)).getAddresses().get(0) : (String)configuration.getGlobal().getServerConnector().getAddresses().get(0);
        String[] tokens = serverAddress.split(":");
        try (Socket socket = new Socket(tokens[0], Integer.parseInt(tokens[1]));){
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
    }

    private static NetworkInterface resolveNetworkInterface(String nic) {
        NetworkInterface ni = null;
        try {
            ni = NetworkInterface.getByName(nic);
        }
        catch (SocketException e) {
            LOG.error("[ReportClient]get nic failed, nic:{}", (Object)nic, (Object)e);
        }
        if (null != ni) {
            return ni;
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.getInetAddresses().hasMoreElements()) continue;
                return networkInterface;
            }
        }
        catch (SocketException e) {
            LOG.error("[ReportClient]get all network interfaces failed", (Throwable)e);
        }
        return null;
    }

    private static String resolveAddress(String nic) {
        NetworkInterface ni = SDKContext.resolveNetworkInterface(nic);
        if (null == ni) {
            return DEFAULT_ADDRESS;
        }
        Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
        if (inetAddresses.hasMoreElements()) {
            InetAddress inetAddress = inetAddresses.nextElement();
            return inetAddress.getCanonicalHostName();
        }
        return DEFAULT_ADDRESS;
    }

    public synchronized void init() throws PolarisException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        this.extensions.init(this.configuration, (Supplier)this.plugins, this.valueContext);
        this.plugins.postContextInitPlugins(this.extensions);
        this.extensions.initHttpServer(this.configuration, (Supplier)this.plugins);
        this.reportClient(this.extensions);
        this.registerDestroyHook((Destroyable)this.extensions);
    }

    private boolean clusterAvailable(ClusterConfig clusterConfig) {
        if (null == clusterConfig) {
            return false;
        }
        if (StringUtils.isBlank((String)clusterConfig.getNamespace()) || StringUtils.isBlank((String)clusterConfig.getService())) {
            return false;
        }
        return !clusterConfig.isSameAsBuiltin();
    }

    private void reportClient(Extensions extensions) {
        if (extensions.getConfiguration().getGlobal().getAPI().isReportEnable()) {
            this.reportClientExecutorService.scheduleAtFixedRate(() -> {
                ServerConnector serverConnector = extensions.getServerConnector();
                ReportClientRequest reportClientRequest = new ReportClientRequest();
                reportClientRequest.setClientHost(extensions.getValueContext().getHost());
                reportClientRequest.setVersion("2.0.0.0");
                List statPlugins = extensions.getStatReporters();
                ArrayList<ReporterMetaInfo> reporterMetaInfos = new ArrayList<ReporterMetaInfo>();
                for (StatReporter statPlugin : statPlugins) {
                    ReporterMetaInfo reporterMetaInfo = statPlugin.metaInfo();
                    if (!StringUtils.isNotBlank((String)reporterMetaInfo.getProtocol())) continue;
                    reporterMetaInfos.add(reporterMetaInfo);
                }
                reportClientRequest.setReporterMetaInfos(reporterMetaInfos);
                try {
                    ReportClientResponse reportClientResponse = serverConnector.reportClient(reportClientRequest);
                    LOG.debug("Report client success, response:{}", (Object)reportClientResponse);
                }
                catch (PolarisException e) {
                    LOG.error("Report client failed.", (Throwable)e);
                }
            }, 0L, 60L, TimeUnit.SECONDS);
        }
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Supplier getPlugins() {
        return this.plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDestroy() {
        Object object = this.lock;
        synchronized (object) {
            for (Destroyable destroyable : this.destroyHooks) {
                destroyable.destroy();
            }
        }
        this.plugins.destroyPlugins();
        if (Objects.nonNull(this.reportClientExecutorService)) {
            this.reportClientExecutorService.shutdown();
        }
    }

    public ValueContext getValueContext() {
        return this.valueContext;
    }

    public Collection<ServerServiceInfo> getServerServices() {
        return this.serverServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestroyHook(Destroyable destroyable) {
        Object object = this.lock;
        synchronized (object) {
            this.destroyHooks.add(destroyable);
        }
    }

    @Override
    public void close() {
        this.destroy();
    }

    private static <T extends AbstractFlow> T loadFlow(String name, Class<T> clazz) {
        ServiceLoader<AbstractFlow> flows = ServiceLoader.load(clazz);
        for (AbstractFlow flow : flows) {
            if (!StringUtils.equals((String)flow.getName(), (String)name)) continue;
            return (T)flow;
        }
        throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("unknown flow name %s, type is %s", name, clazz.getCanonicalName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractFlow> T getOrInitFlow(Class<T> clazz) {
        Class<T> clazz2 = clazz;
        synchronized (clazz2) {
            Object flowObject = this.valueContext.getValue(clazz.getCanonicalName());
            if (null != flowObject) {
                return (T)((AbstractFlow)flowObject);
            }
            String flowName = this.configuration.getGlobal().getSystem().getFlow().getName();
            T flow = SDKContext.loadFlow(flowName, clazz);
            flow.setSDKContext(this);
            this.valueContext.setValue(clazz.getCanonicalName(), flow);
            return flow;
        }
    }
}

