/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.consumer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.consumer.ConsumerConfig;
import com.tencent.polaris.factory.config.consumer.CircuitBreakerConfigImpl;
import com.tencent.polaris.factory.config.consumer.LoadBalanceConfigImpl;
import com.tencent.polaris.factory.config.consumer.LocalCacheConfigImpl;
import com.tencent.polaris.factory.config.consumer.OutlierDetectionConfigImpl;
import com.tencent.polaris.factory.config.consumer.ServiceRouterConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;

public class ConsumerConfigImpl
implements ConsumerConfig {
    @JsonProperty
    private LocalCacheConfigImpl localCache;
    @JsonProperty
    private ServiceRouterConfigImpl serviceRouter;
    @JsonProperty
    private LoadBalanceConfigImpl loadbalancer;
    @JsonProperty
    private CircuitBreakerConfigImpl circuitBreaker;
    @JsonProperty
    private OutlierDetectionConfigImpl outlierDetection;

    @Override
    public LocalCacheConfigImpl getLocalCache() {
        return this.localCache;
    }

    @Override
    public ServiceRouterConfigImpl getServiceRouter() {
        return this.serviceRouter;
    }

    @Override
    public LoadBalanceConfigImpl getLoadbalancer() {
        return this.loadbalancer;
    }

    @Override
    public CircuitBreakerConfigImpl getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public OutlierDetectionConfigImpl getOutlierDetection() {
        return this.outlierDetection;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.localCache, "localCache");
        ConfigUtils.validateNull(this.serviceRouter, "serviceRouter");
        ConfigUtils.validateNull(this.loadbalancer, "loadbalancer");
        ConfigUtils.validateNull(this.circuitBreaker, "circuitBreaker");
        ConfigUtils.validateNull(this.outlierDetection, "outlierDetection");
        this.localCache.verify();
        this.serviceRouter.verify();
        this.loadbalancer.verify();
        this.circuitBreaker.verify();
        this.outlierDetection.verify();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null == this.localCache) {
            this.localCache = new LocalCacheConfigImpl();
        }
        if (null == this.serviceRouter) {
            this.serviceRouter = new ServiceRouterConfigImpl();
        }
        if (null == this.loadbalancer) {
            this.loadbalancer = new LoadBalanceConfigImpl();
        }
        if (null == this.circuitBreaker) {
            this.circuitBreaker = new CircuitBreakerConfigImpl();
        }
        if (null == this.outlierDetection) {
            this.outlierDetection = new OutlierDetectionConfigImpl();
        }
        if (null != defaultObject) {
            ConsumerConfig consumerConfig = (ConsumerConfig)defaultObject;
            this.localCache.setDefault(consumerConfig.getLocalCache());
            this.serviceRouter.setDefault(consumerConfig.getServiceRouter());
            this.loadbalancer.setDefault(consumerConfig.getLoadbalancer());
            this.circuitBreaker.setDefault(consumerConfig.getCircuitBreaker());
            this.outlierDetection.setDefault(consumerConfig.getOutlierDetection());
        }
    }

    public String toString() {
        return "ConsumerConfigImpl{localCache=" + this.localCache + ", serviceRouter=" + this.serviceRouter + ", loadbalancer=" + this.loadbalancer + ", circuitBreaker=" + this.circuitBreaker + ", outlierDetection=" + this.outlierDetection + '}';
    }
}

