/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.provider;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.provider.RateLimitConfig;
import com.tencent.polaris.factory.config.plugin.PluginConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;

public class RateLimitConfigImpl
extends PluginConfigImpl
implements RateLimitConfig {
    @JsonProperty
    private Boolean enable;
    @JsonProperty
    private Integer maxWindowCount;
    @JsonProperty
    private RateLimitConfig.Fallback fallbackOnExceedWindowCount;

    @Override
    public boolean isEnable() {
        if (null == this.enable) {
            return false;
        }
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Override
    public int getMaxWindowCount() {
        if (null == this.maxWindowCount) {
            return 0;
        }
        return this.maxWindowCount;
    }

    public void setMaxWindowCount(int maxWindowCount) {
        this.maxWindowCount = maxWindowCount;
    }

    @Override
    public RateLimitConfig.Fallback getFallbackOnExceedWindowCount() {
        return this.fallbackOnExceedWindowCount;
    }

    public void setFallbackOnExceedWindowCount(RateLimitConfig.Fallback fallbackOnExceedWindowCount) {
        this.fallbackOnExceedWindowCount = fallbackOnExceedWindowCount;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.enable, "rateLimit.enable");
        if (!this.enable.booleanValue()) {
            return;
        }
        ConfigUtils.validatePositive(this.maxWindowCount, "rateLimit.maxWindowCount");
        ConfigUtils.validateNull((Object)this.fallbackOnExceedWindowCount, "rateLimit.fallbackOnExceedWindowCount");
        this.verifyPluginConfig();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            RateLimitConfig rateLimitConfig = (RateLimitConfig)defaultObject;
            if (null == this.enable) {
                this.setEnable(rateLimitConfig.isEnable());
            }
            if (null == this.maxWindowCount) {
                this.setMaxWindowCount(rateLimitConfig.getMaxWindowCount());
            }
            if (null == this.fallbackOnExceedWindowCount) {
                this.setFallbackOnExceedWindowCount(rateLimitConfig.getFallbackOnExceedWindowCount());
            }
            this.setDefaultPluginConfig(rateLimitConfig);
        }
    }
}

