/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.provider.ProviderConfig;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.factory.config.provider.RateLimitConfigImpl;
import com.tencent.polaris.factory.config.provider.RegisterConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProviderConfigImpl
implements ProviderConfig {
    private static final long DEFAULT_MIN_REGISTER_INTERVAL = 30000L;
    @JsonProperty
    private RateLimitConfigImpl rateLimit;
    @JsonProperty
    private List<RegisterConfigImpl> registers;
    @JsonIgnore
    private final Map<String, RegisterConfigImpl> registerConfigMap = new ConcurrentHashMap<String, RegisterConfigImpl>();
    @JsonProperty
    private long minRegisterInterval;

    @Override
    public RateLimitConfigImpl getRateLimit() {
        return this.rateLimit;
    }

    @Override
    public long getMinRegisterInterval() {
        return this.minRegisterInterval;
    }

    public List<RegisterConfigImpl> getRegisters() {
        if (CollectionUtils.isEmpty(this.registers)) {
            this.registers = new ArrayList<RegisterConfigImpl>();
        }
        return this.registers;
    }

    private void setRegisterConfigMap(List<RegisterConfigImpl> registers) {
        if (CollectionUtils.isNotEmpty(registers)) {
            for (RegisterConfigImpl registerConfig : registers) {
                if (this.registerConfigMap.containsKey(registerConfig.getServerConnectorId())) {
                    throw new IllegalArgumentException(String.format("Register config of [%s] is already exist.", registerConfig.getServerConnectorId()));
                }
                this.registerConfigMap.put(registerConfig.getServerConnectorId(), registerConfig);
            }
        }
    }

    public Map<String, RegisterConfigImpl> getRegisterConfigMap() {
        return this.registerConfigMap;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.rateLimit, "rateLimitConfig");
        this.rateLimit.verify();
        if (CollectionUtils.isNotEmpty(this.registers)) {
            for (RegisterConfigImpl registerConfig : this.registers) {
                registerConfig.verify();
            }
        }
        this.setRegisterConfigMap(this.registers);
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null == this.rateLimit) {
            this.rateLimit = new RateLimitConfigImpl();
        }
        if (this.minRegisterInterval == 0L) {
            this.minRegisterInterval = 30000L;
        }
        if (null != defaultObject) {
            ProviderConfig providerConfig = (ProviderConfig)defaultObject;
            this.rateLimit.setDefault(providerConfig.getRateLimit());
            if (CollectionUtils.isNotEmpty(this.registers)) {
                for (RegisterConfigImpl registerConfig : this.registers) {
                    registerConfig.setDefault(providerConfig.getRegisters().get(0));
                }
            } else {
                this.registers = new ArrayList<RegisterConfigImpl>();
            }
        }
    }
}

