/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.consumer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.factory.config.plugin.PluginConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;
import java.util.List;

public class OutlierDetectionConfigImpl
extends PluginConfigImpl
implements OutlierDetectionConfig {
    @JsonProperty
    private OutlierDetectionConfig.When when;
    @JsonProperty
    private List<String> chain;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long checkPeriod;

    @Override
    public OutlierDetectionConfig.When getWhen() {
        return this.when;
    }

    public void setWhen(OutlierDetectionConfig.When when) {
        this.when = when;
    }

    @Override
    public List<String> getChain() {
        return this.chain;
    }

    public void setChain(List<String> chain) {
        this.chain = chain;
    }

    @Override
    public long getCheckPeriod() {
        if (null == this.checkPeriod) {
            return 0L;
        }
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull((Object)this.when, "outlierDetection.enable");
        if (this.when == OutlierDetectionConfig.When.never) {
            return;
        }
        ConfigUtils.validateIntervalWithMin(this.checkPeriod, 100L, "outlierDetection.checkPeriod");
        if (CollectionUtils.isEmpty(this.chain)) {
            throw new IllegalArgumentException("outlierDetection.chain cannot be empty");
        }
        this.verifyPluginConfig();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            OutlierDetectionConfig outlierDetectionConfig = (OutlierDetectionConfig)defaultObject;
            if (null == this.when) {
                this.setWhen(outlierDetectionConfig.getWhen());
            }
            if (null == this.checkPeriod) {
                this.setCheckPeriod(outlierDetectionConfig.getCheckPeriod());
            }
            if (CollectionUtils.isEmpty(this.chain)) {
                this.setChain(outlierDetectionConfig.getChain());
            }
            if (this.when != OutlierDetectionConfig.When.never) {
                this.setDefaultPluginConfig(outlierDetectionConfig);
            }
        }
    }

    public String toString() {
        return "OutlierDetectionConfigImpl{when=" + (Object)((Object)this.when) + ", chain=" + this.chain + ", checkPeriod=" + this.checkPeriod + "} " + super.toString();
    }
}

