/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.global;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.tencent.polaris.api.config.global.APIConfig;
import com.tencent.polaris.factory.util.ConfigUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;

public class APIConfigImpl
implements APIConfig {
    @JsonProperty
    private Integer maxRetryTimes;
    @JsonProperty
    private String bindIf;
    @JsonProperty
    private String bindIP;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long timeout;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long reportInterval;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long retryInterval;

    @Override
    public int getMaxRetryTimes() {
        if (null == this.maxRetryTimes) {
            return 0;
        }
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public String getBindIf() {
        return this.bindIf;
    }

    @Override
    public String getBindIP() {
        return this.bindIP;
    }

    public void setBindIP(String bindIP) {
        this.bindIP = bindIP;
    }

    public void setBindIf(String bindIf) {
        this.bindIf = bindIf;
    }

    @Override
    public long getTimeout() {
        if (null == this.timeout) {
            return 0L;
        }
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getReportInterval() {
        if (null == this.reportInterval) {
            return 0L;
        }
        return this.reportInterval;
    }

    public void setReportInterval(long reportInterval) {
        this.reportInterval = reportInterval;
    }

    @Override
    public long getRetryInterval() {
        if (null == this.retryInterval) {
            return 0L;
        }
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public void verify() {
        ConfigUtils.validateTimes(this.maxRetryTimes, "api.maxRetryTimes");
        ConfigUtils.validateInterval(this.timeout, "api.timeout");
        ConfigUtils.validateInterval(this.reportInterval, "api.reportInterval");
        ConfigUtils.validateInterval(this.retryInterval, "api.retryInterval");
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            APIConfig apiConfig = (APIConfig)defaultObject;
            if (null == this.maxRetryTimes) {
                this.setMaxRetryTimes(apiConfig.getMaxRetryTimes());
            }
            if (null == this.bindIf) {
                this.setBindIf(apiConfig.getBindIf());
            }
            if (null == this.bindIP) {
                this.setBindIP(apiConfig.getBindIP());
            }
            if (null == this.timeout) {
                this.setTimeout(apiConfig.getTimeout());
            }
            if (null == this.reportInterval) {
                this.setReportInterval(apiConfig.getReportInterval());
            }
            if (null == this.retryInterval) {
                this.setRetryInterval(apiConfig.getRetryInterval());
            }
        }
    }

    public String toString() {
        return "APIConfigImpl{maxRetryTimes=" + this.maxRetryTimes + ", bindIf='" + this.bindIf + '\'' + ", bindIP='" + this.bindIP + '\'' + ", timeout=" + this.timeout + ", reportInterval=" + this.reportInterval + ", retryInterval=" + this.retryInterval + '}';
    }
}

