/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tencent.polaris.api.config.configuration.ConfigFilterConfig;
import com.tencent.polaris.api.config.configuration.CryptoConfig;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.factory.config.configuration.CryptoConfigImpl;
import com.tencent.polaris.factory.config.plugin.PluginConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFilterConfigImpl
extends PluginConfigImpl
implements ConfigFilterConfig {
    @JsonProperty
    private Boolean enable;
    @JsonProperty
    private List<String> chain;

    @Override
    public boolean isEnable() {
        return this.enable != null && this.enable != false;
    }

    @Override
    public List<String> getChain() {
        return this.chain;
    }

    @Override
    public Map<String, Verifier> getPluginConfigs() throws PolarisException {
        HashMap<String, Verifier> values = new HashMap<String, Verifier>();
        this.chain.forEach(chain -> {
            CryptoConfig cryptoConfig = super.getPluginConfig((String)chain, CryptoConfigImpl.class);
            values.put((String)chain, cryptoConfig);
        });
        return values;
    }

    @Override
    public void verify() {
        if (!this.isEnable()) {
            return;
        }
        ConfigUtils.validateNull(this.chain, "ConfigFilterConfig Chain");
        ConfigUtils.validateNull(this.getPlugin(), "ConfigFilterConfig Plugin");
        if (this.getPlugin().size() != this.chain.size()) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, "ConfigFilterConfig plugin config does not match chain");
        }
        this.chain.forEach(chain -> ConfigUtils.validateNull(this.getPlugin().get(chain), "ConfigFilter plugin config for chain " + chain));
        this.verifyPluginConfig();
    }

    @Override
    public void setDefault(Object defaultObject) {
    }
}

