/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.global;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.tencent.polaris.api.config.global.FlowCacheConfig;
import com.tencent.polaris.factory.util.ConfigUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;

public class FlowCacheConfigImpl
implements FlowCacheConfig {
    @JsonProperty
    private Boolean enable;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long expireInterval;
    @JsonProperty
    private String name;

    @Override
    public boolean isEnable() {
        if (null == this.enable) {
            return false;
        }
        return this.enable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getExpireInterval() {
        if (null == this.expireInterval) {
            return 0L;
        }
        return this.expireInterval;
    }

    public void setExpireInterval(long expireInterval) {
        this.expireInterval = expireInterval;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.enable, "flowCache.enable");
        ConfigUtils.validateInterval(this.expireInterval, "flowCache.expireInterval");
        ConfigUtils.validateString(this.name, "flowCache.name");
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            FlowCacheConfig flowCacheConfig = (FlowCacheConfig)defaultObject;
            if (null == this.enable) {
                this.setEnable(flowCacheConfig.isEnable());
            }
            if (null == this.name) {
                this.setName(flowCacheConfig.getName());
            }
            if (null == this.expireInterval) {
                this.setExpireInterval(flowCacheConfig.getExpireInterval());
            }
        }
    }

    public String toString() {
        return "FlowCacheConfigImpl{enable=" + this.enable + ", expireInterval=" + this.expireInterval + ", name='" + this.name + '\'' + '}';
    }
}

