/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.consumer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.tencent.polaris.api.config.consumer.LocalCacheConfig;
import com.tencent.polaris.api.config.verify.DefaultValues;
import com.tencent.polaris.factory.config.plugin.PluginConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;

public class LocalCacheConfigImpl
extends PluginConfigImpl
implements LocalCacheConfig {
    @JsonProperty
    private Boolean serviceExpireEnable;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long serviceExpireTime;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long serviceRefreshInterval;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long serviceListRefreshInterval;
    @JsonProperty
    private Boolean persistEnable;
    @JsonProperty
    private String persistDir;
    @JsonProperty
    private String type;
    @JsonProperty
    private Integer persistMaxWriteRetry;
    @JsonProperty
    private Integer persistMaxReadRetry;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long persistRetryInterval;

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isPersistEnable() {
        if (null == this.persistEnable) {
            return false;
        }
        return this.persistEnable;
    }

    public void setPersistEnable(Boolean persistEnable) {
        this.persistEnable = persistEnable;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int getPersistMaxWriteRetry() {
        if (null == this.persistMaxWriteRetry) {
            return 0;
        }
        return this.persistMaxWriteRetry;
    }

    public void setPersistMaxWriteRetry(int persistMaxWriteRetry) {
        this.persistMaxWriteRetry = persistMaxWriteRetry;
    }

    @Override
    public int getPersistMaxReadRetry() {
        if (null == this.persistMaxReadRetry) {
            return 0;
        }
        return this.persistMaxReadRetry;
    }

    public void setPersistMaxReadRetry(int persistMaxReadRetry) {
        this.persistMaxReadRetry = persistMaxReadRetry;
    }

    @Override
    public boolean isServiceExpireEnable() {
        if (null == this.serviceExpireEnable) {
            return false;
        }
        return this.serviceExpireEnable;
    }

    public void setServiceExpireEnable(boolean serviceExpireEnable) {
        this.serviceExpireEnable = serviceExpireEnable;
    }

    @Override
    public long getServiceExpireTime() {
        if (null == this.serviceExpireTime) {
            return 0L;
        }
        return this.serviceExpireTime;
    }

    public void setServiceExpireTime(long serviceExpireTime) {
        this.serviceExpireTime = serviceExpireTime;
    }

    @Override
    public long getServiceRefreshInterval() {
        if (null == this.serviceRefreshInterval) {
            return 0L;
        }
        return this.serviceRefreshInterval;
    }

    public void setServiceRefreshInterval(long serviceRefreshInterval) {
        this.serviceRefreshInterval = serviceRefreshInterval;
    }

    @Override
    public long getServiceListRefreshInterval() {
        return this.serviceListRefreshInterval;
    }

    public void setServiceListRefreshInterval(Long serviceListRefreshInterval) {
        this.serviceListRefreshInterval = serviceListRefreshInterval;
    }

    @Override
    public long getPersistRetryInterval() {
        if (null == this.persistRetryInterval) {
            return 0L;
        }
        return this.persistRetryInterval;
    }

    public void setPersistRetryInterval(long persistRetryInterval) {
        this.persistRetryInterval = persistRetryInterval;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.serviceExpireEnable, "localCache.serviceExpireEnable");
        ConfigUtils.validateIntervalWithMin(this.serviceExpireTime, DefaultValues.MIN_SERVICE_EXPIRE_TIME_MS, "localCache.serviceExpireTime");
        ConfigUtils.validateIntervalWithMin(this.serviceRefreshInterval, DefaultValues.MIN_SERVICE_REFRESH_INTERVAL_MS, "localCache.serviceRefreshInterval");
        ConfigUtils.validateNull(this.persistEnable, "localCache.persistEnable");
        if (this.persistEnable.booleanValue()) {
            ConfigUtils.validateString(this.persistDir, "localCache.persistDir");
        }
        ConfigUtils.validateString(this.type, "localCache.type");
        ConfigUtils.validateTimes(this.persistMaxWriteRetry, "localCache.persistMaxWriteRetry");
        ConfigUtils.validateTimes(this.persistMaxReadRetry, "localCache.persistMaxReadRetry");
        ConfigUtils.validateInterval(this.persistRetryInterval, "localCache.persistRetryInterval");
        this.verifyPluginConfig();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            LocalCacheConfig localCacheConfig = (LocalCacheConfig)defaultObject;
            if (null == this.serviceExpireEnable) {
                this.setServiceExpireEnable(localCacheConfig.isServiceExpireEnable());
            }
            if (null == this.serviceExpireTime) {
                this.setServiceExpireTime(localCacheConfig.getServiceExpireTime());
            }
            if (null == this.serviceRefreshInterval) {
                this.setServiceRefreshInterval(localCacheConfig.getServiceRefreshInterval());
            }
            if (null == this.serviceListRefreshInterval) {
                this.setServiceListRefreshInterval(localCacheConfig.getServiceListRefreshInterval());
            }
            if (null == this.persistEnable) {
                this.setPersistEnable(localCacheConfig.isPersistEnable());
            }
            if (null == this.persistDir) {
                this.setPersistDir(localCacheConfig.getPersistDir());
            }
            if (null == this.type) {
                this.setType(localCacheConfig.getType());
            }
            if (null == this.persistMaxWriteRetry) {
                this.setPersistMaxWriteRetry(localCacheConfig.getPersistMaxWriteRetry());
            }
            if (null == this.persistMaxReadRetry) {
                this.setPersistMaxReadRetry(localCacheConfig.getPersistMaxReadRetry());
            }
            if (null == this.persistRetryInterval) {
                this.setPersistRetryInterval(localCacheConfig.getPersistRetryInterval());
            }
            this.setDefaultPluginConfig(localCacheConfig);
        }
    }

    public String toString() {
        return "LocalCacheConfigImpl{serviceExpireEnable=" + this.serviceExpireEnable + ", serviceExpireTime=" + this.serviceExpireTime + ", serviceRefreshInterval=" + this.serviceRefreshInterval + ", persistEnable=" + this.persistEnable + ", persistDir='" + this.persistDir + '\'' + ", type='" + this.type + '\'' + ", persistMaxWriteRetry=" + this.persistMaxWriteRetry + ", persistMaxReadRetry=" + this.persistMaxReadRetry + ", persistRetryInterval=" + this.persistRetryInterval + "} " + super.toString();
    }
}

